/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InstantiationConfig;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.security.Permission;
import java.util.logging.Logger;

public class PermissionConfig {
    static final Logger log = Log.open(PermissionConfig._resin_compat_class_1());
    static final L10N L = new L10N(PermissionConfig._resin_compat_class_1());
    private InstantiationConfig _type;
    private Permission _perm;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setType(InstantiationConfig type) throws ConfigException {
        if (!PermissionConfig._resin_compat_class_0().isAssignableFrom(type.getType())) {
            throw new ConfigException(L.l("`{0}' must extend java.security.Permission", type));
        }
        this._type = type;
    }

    public void addArg(Object obj) {
        this._type.addArg(obj);
    }

    public void init() throws Exception {
        this._perm = (Permission)this._type.create();
    }

    public Permission getPermission() {
        return this._perm;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.security.Permission");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.security.PermissionConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

