/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources.rmi;

import com.caucho.config.ConfigException;
import com.caucho.jca.AbstractResourceAdapter;
import com.caucho.log.Log;
import com.caucho.resources.rmi.RmiService;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;

public class RmiRegistry
extends AbstractResourceAdapter {
    protected static final Logger log = Log.open(RmiRegistry._resin_compat_class_0());
    static final L10N L = new L10N(RmiRegistry._resin_compat_class_0());
    private String _server = "localhost";
    private int _port = 1099;
    private LinkedList<RmiService> _services = new LinkedList();
    private String _namePrefix;
    private static Class _resin_compat_class_0;

    public void setServer(String server) {
        this._server = server;
    }

    public String getServer() {
        return this._server;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void addRmiService(RmiService service) throws ConfigException {
        this._services.add(service);
    }

    public void init() throws ConfigException {
        if (System.getSecurityManager() == null) {
            throw new ConfigException("RMI requires a SecurityManager - add a <security-manager/> element to <resin>");
        }
        this._namePrefix = new CharBuffer().append("//").append(this._server).append(':').append(this._port).append('/').toString();
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        System.out.println("START:");
        if (this._server.equals("localhost")) {
            this.startRegistry();
        } else {
            log.config(L.l("using remote RMI Registry `{0}:{1}'", (Object)this._server, String.valueOf(this._port)));
        }
        Iterator i = this._services.iterator();
        while (i.hasNext()) {
            RmiService s = (RmiService)i.next();
            s.start();
        }
    }

    String makeFullName(String serviceName) {
        return new CharBuffer().append(this._namePrefix).append(serviceName).toString();
    }

    private void startRegistry() throws ResourceAdapterInternalException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            try {
                Registry reg = LocateRegistry.getRegistry(this._port);
                reg.list();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(L.l("found RMI Registry on port `{0}'", this._port));
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(L.l("creating RMI Registry on port `{0}'", this._port));
                }
                LocateRegistry.createRegistry(this._port);
            }
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException((Throwable)ex);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void stop() throws ResourceAdapterInternalException {
        Iterator i = this._services.iterator();
        while (i.hasNext()) {
            RmiService s = (RmiService)i.next();
            s.stop();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.resources.rmi.RmiRegistry");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

