/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.DataPattern;
import com.caucho.relaxng.pattern.EmptyPattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.InterleaveItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class InterleavePattern
extends Pattern {
    private ArrayList<Pattern> _patterns = new ArrayList();
    private Item _item;

    public String getTagName() {
        return "interleave";
    }

    public int getSize() {
        return this._patterns.size();
    }

    public Pattern getChild(int i) {
        return this._patterns.get(i);
    }

    public boolean hasData() {
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (!this._patterns.get(i).hasData()) continue;
            return true;
        }
        return false;
    }

    public boolean hasElement() {
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (!this._patterns.get(i).hasElement()) continue;
            return true;
        }
        return false;
    }

    public void addChild(Pattern child) throws RelaxException {
        if (child instanceof DataPattern) {
            throw new RelaxException(L.l("<data> or <string> may not be used with interleave.  Use <text> instead."));
        }
        if (child instanceof EmptyPattern) {
            throw new RelaxException(L.l("<empty> is not allowed as a child of <interleave>"));
        }
        child.setParent(this);
        child.setElementName(this.getElementName());
        if (child instanceof InterleavePattern) {
            InterleavePattern interleave = (InterleavePattern)child;
            for (int i = 0; i < interleave.getSize(); ++i) {
                this.addChild(interleave.getChild(i));
            }
            return;
        }
        if (this._patterns.contains(child)) {
            return;
        }
        this._patterns.add(child);
    }

    public Item createItem(GrammarPattern grammar) throws RelaxException {
        if (this._item == null) {
            InterleaveItem item = new InterleaveItem();
            for (int i = 0; i < this._patterns.size(); ++i) {
                item.addItem(this._patterns.get(i).createItem(grammar));
            }
            this._item = item.getMin();
        }
        return this._item;
    }

    public String toProduction() {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (i != 0) {
                cb.append(" & ");
            }
            cb.append(this._patterns.get(i).toProduction());
        }
        return cb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterleavePattern)) {
            return false;
        }
        InterleavePattern interleave = (InterleavePattern)o;
        if (this._patterns.size() != interleave._patterns.size()) {
            return false;
        }
        return this.isSubset(interleave) && interleave.isSubset(this);
    }

    private boolean isSubset(InterleavePattern item) {
        if (this._patterns.size() != item._patterns.size()) {
            return false;
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            Pattern subPattern = this._patterns.get(i);
            if (item._patterns.contains(subPattern)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new CharBuffer().append("InterleavePattern").append(this._patterns).toString();
    }
}

