/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.GroupPattern;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.ElementItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;

public class ElementPattern
extends Pattern {
    private String _defName;
    private NameClassPattern _name;
    private GroupPattern _children = new GroupPattern();
    private Item _item;

    public ElementPattern(String defName) {
        this._defName = defName;
    }

    public String getTagName() {
        return "element";
    }

    public String getDefName() {
        return this._defName;
    }

    public GroupPattern getChildren() {
        return this._children;
    }

    public boolean hasElement() {
        return true;
    }

    public void addNameChild(NameClassPattern child) throws RelaxException {
        this._name = child;
        this.setElementName(this._name.toProduction());
    }

    public NameClassPattern getNameChild() throws RelaxException {
        return this._name;
    }

    public void addChild(Pattern child) throws RelaxException {
        if (this._name == null) {
            throw new RelaxException(L.l("<element> must have <name> definitions before other children."));
        }
        child.setParent(this._children);
        child.setElementName(this._children.getElementName());
        this._children.addChild(child);
    }

    public void endElement() throws RelaxException {
        if (this._name == null) {
            throw new RelaxException(L.l("<element> must have a <name> definition."));
        }
        if (this._children.getSize() == 0) {
            throw new RelaxException(L.l("<element> tag `{0}' must have a child grammar production.", this._name.toProduction()));
        }
    }

    public Item createItem(GrammarPattern grammar) throws RelaxException {
        if (this._item == null) {
            ElementItem item = new ElementItem(this, this._name.createNameItem());
            this._item = item;
            item.setChildrenItem(this._children.createItem(grammar));
        }
        return this._item;
    }

    public String toProduction() {
        return this._name.toProduction();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementPattern)) {
            return false;
        }
        ElementPattern elt = (ElementPattern)o;
        return this._defName.equals(elt._defName);
    }

    public String toString() {
        return new CharBuffer().append("ElementPattern[").append(this._name).append("]").toString();
    }
}

