/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.EmptyPattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.ChoiceItem;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class ChoicePattern
extends Pattern {
    private ArrayList<Pattern> _patterns = new ArrayList();
    private boolean _hasEmpty;
    private Item _item;

    public int getSize() {
        return this._patterns.size();
    }

    public Pattern getChild(int i) {
        return this._patterns.get(i);
    }

    public boolean hasEmpty() {
        return this._hasEmpty;
    }

    public boolean hasData() {
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (!this._patterns.get(i).hasData()) continue;
            return true;
        }
        return false;
    }

    public boolean hasElement() {
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (!this._patterns.get(i).hasElement()) continue;
            return true;
        }
        return false;
    }

    public void addChild(Pattern child) throws RelaxException {
        child.setElementName(this.getElementName());
        if (child instanceof ChoicePattern) {
            ChoicePattern list = (ChoicePattern)child;
            if (list._hasEmpty) {
                this._hasEmpty = true;
            }
            for (int i = 0; i < list.getSize(); ++i) {
                this.addChild(list.getChild(i));
            }
            return;
        }
        if (child instanceof EmptyPattern) {
            this._hasEmpty = true;
            return;
        }
        if (!this._patterns.contains(child)) {
            this._patterns.add(child);
        }
    }

    public String getTagName() {
        return "choice";
    }

    public Item createItem(GrammarPattern grammar) throws RelaxException {
        if (this._item == null) {
            ChoiceItem item = new ChoiceItem();
            for (int i = 0; i < this._patterns.size(); ++i) {
                item.addItem(this._patterns.get(i).createItem(grammar));
            }
            if (this._hasEmpty) {
                item.addItem(EmptyItem.create());
            }
            this._item = item.getMin();
        }
        return this._item;
    }

    public String toProduction() {
        if (this._hasEmpty && this._patterns.size() == 1) {
            return new CharBuffer().append("(").append(this._patterns.get(0).toProduction()).append(")?").toString();
        }
        CharBuffer cb = new CharBuffer();
        if (this._hasEmpty) {
            cb.append("(");
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (i != 0) {
                cb.append(" | ");
            }
            cb.append(this._patterns.get(i).toProduction());
        }
        if (this._hasEmpty) {
            cb.append(")?");
        }
        return cb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChoicePattern)) {
            return false;
        }
        ChoicePattern choice = (ChoicePattern)o;
        if (this._hasEmpty != choice._hasEmpty) {
            return false;
        }
        if (this._patterns.size() != choice._patterns.size()) {
            return false;
        }
        return this.isSubset(choice) && choice.isSubset(this);
    }

    private boolean isSubset(ChoicePattern item) {
        if (this._patterns.size() != item._patterns.size()) {
            return false;
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            Pattern subPattern = this._patterns.get(i);
            if (item._patterns.contains(subPattern)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new CharBuffer().append("ChoicePattern").append(this._patterns).toString();
    }
}

