/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.ChoiceNameItem;
import com.caucho.relaxng.program.NameClassItem;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class ChoiceNamePattern
extends NameClassPattern {
    private ArrayList<NameClassPattern> _patterns = new ArrayList();
    private NameClassItem _item;

    public int getSize() {
        return this._patterns.size();
    }

    public NameClassPattern getChild(int i) {
        return this._patterns.get(i);
    }

    public void addNameChild(NameClassPattern child) throws RelaxException {
        if (child instanceof ChoiceNamePattern) {
            ChoiceNamePattern list = (ChoiceNamePattern)child;
            for (int i = 0; i < list.getSize(); ++i) {
                this.addChild(list.getChild(i));
            }
            return;
        }
        if (!this._patterns.contains(child)) {
            this._patterns.add(child);
        }
    }

    public String getTagName() {
        return "choice";
    }

    public NameClassItem createNameItem() throws RelaxException {
        if (this._item == null) {
            ChoiceNameItem item = new ChoiceNameItem();
            for (int i = 0; i < this._patterns.size(); ++i) {
                item.addItem(this._patterns.get(i).createNameItem());
            }
            this._item = item.getMin();
        }
        return this._item;
    }

    public String toProduction() {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (i != 0) {
                cb.append(" | ");
            }
            cb.append(this._patterns.get(i).toProduction());
        }
        return cb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChoiceNamePattern)) {
            return false;
        }
        ChoiceNamePattern choice = (ChoiceNamePattern)o;
        if (this._patterns.size() != choice._patterns.size()) {
            return false;
        }
        return this.isSubset(choice) && choice.isSubset(this);
    }

    private boolean isSubset(ChoiceNamePattern item) {
        if (this._patterns.size() != item._patterns.size()) {
            return false;
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            Pattern subPattern = this._patterns.get(i);
            if (item._patterns.contains(subPattern)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new CharBuffer().append("ChoiceNamePattern").append(this._patterns).toString();
    }
}

