/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.GroupPattern;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.AttributeItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;

public class AttributePattern
extends Pattern {
    private NameClassPattern _name;
    private GroupPattern _children = new GroupPattern();
    private Item _item;

    public String getTagName() {
        return "attribute";
    }

    public GroupPattern getChildren() {
        return this._children;
    }

    public void addNameChild(NameClassPattern child) throws RelaxException {
        this._name = child;
        this.setElementName(this._name.toProduction());
    }

    public NameClassPattern getNameChild() throws RelaxException {
        return this._name;
    }

    public void addChild(Pattern child) throws RelaxException {
        if (this._name == null) {
            throw new RelaxException(L.l("<attribute> must have a <name> definition before any children."));
        }
        child.setParent(this._children);
        child.setElementName(this._children.getElementName());
        this._children.addChild(child);
    }

    public void endElement() throws RelaxException {
        if (this._name == null) {
            throw new RelaxException(L.l("<attribute> must have a <name> definition."));
        }
    }

    public Item createItem(GrammarPattern grammar) throws RelaxException {
        if (this._item == null) {
            this._item = new AttributeItem(this._name.createNameItem());
        }
        return this._item;
    }

    public String toProduction() {
        return new CharBuffer().append("@").append(this._name.toProduction()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributePattern)) {
            return false;
        }
        AttributePattern elt = (AttributePattern)o;
        if (!this._name.equals(elt._name)) {
            return false;
        }
        return this._children.equals(elt._children);
    }

    public String toString() {
        return new CharBuffer().append("AttributePattern[").append(this._name.toProduction()).append("]").toString();
    }
}

