/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.NameValuePair;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleFactory {
    private String _name;
    private Map<String, Object> _defaultMap;
    private Map<Locale, PortletResourceBundle> _bundleMap = new HashMap<Locale, PortletResourceBundle>();

    public ResourceBundleFactory() {
        this._defaultMap = new LinkedHashMap<String, Object>();
        this.addDefault("javax.portlet.title", "");
        this.addDefault("javax.portlet.short-title", "");
        this.addDefault("javax.portlet.keywords", "");
    }

    public void setName(String name) {
        this._name = name;
        this._bundleMap.clear();
    }

    public void addDefault(String key, String value) {
        this._defaultMap.put(key, value);
    }

    public void addDefault(NameValuePair nameValuePair) {
        this.addDefault(nameValuePair.getName(), nameValuePair.getValue());
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        PortletResourceBundle bundle = this._bundleMap.get(locale);
        if (bundle == null) {
            bundle = new PortletResourceBundle(this._name, locale, this._defaultMap);
            this._bundleMap.put(locale, bundle);
        }
        return bundle;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletResourceBundle
    extends ResourceBundle {
        private Locale _locale;
        private Map<String, Object> _defaultMap;
        private ResourceBundle _parent;

        public PortletResourceBundle(String name, Locale locale, Map<String, Object> defaultMap) {
            this._locale = locale;
            this._defaultMap = defaultMap;
            if (name != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this._parent = ResourceBundle.getBundle(name, this._locale, loader);
                super.setParent(this._parent);
            }
        }

        @Override
        public Locale getLocale() {
            return this._parent == null ? this._locale : this._parent.getLocale();
        }

        @Override
        public Object handleGetObject(String key) {
            if (this._parent == null) {
                if (this._defaultMap != null) {
                    return this._defaultMap.get(key);
                }
                return null;
            }
            try {
                return this._parent.getObject(key);
            }
            catch (MissingResourceException ex) {
                if (this._defaultMap != null) {
                    return this._defaultMap.get(key);
                }
                return null;
            }
        }

        public Enumeration getKeys() {
            if (this._defaultMap != null) {
                return Collections.enumeration(this._defaultMap.keySet());
            }
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    }
}

