/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.alpharenderer;

import com.caucho.portal.alpharenderer.HtmlMenu;
import com.caucho.portal.alpharenderer.Location;
import com.caucho.portal.alpharenderer.Menu;
import com.caucho.portal.generic.AbstractRenderer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class HtmlRenderer
extends AbstractRenderer {
    private static L10N L = new L10N(HtmlRenderer._resin_compat_class_0());
    protected static final Logger log = Logger.getLogger(HtmlRenderer._resin_compat_class_0().getName());
    public static final String PREFERENCE_STYLESHEET = "html.stylesheet";
    private String _pageTitle = "Resin Documentation";
    private boolean _compact = false;
    private String _doctype = "html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transistional.dtd\"";
    private String _stylesheet = "portal.css";
    private Location _titleLocation;
    private Menu _windowStateMenu;
    private Menu _portletModeMenu;
    private static Class _resin_compat_class_0;

    public void setPageTitle(String pageTitle) {
        this._pageTitle = pageTitle;
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setCompact(boolean compact) {
        this._compact = compact;
    }

    public boolean isCompact() {
        return this._compact;
    }

    public void setDoctype(String doctype) {
        this._doctype = doctype;
    }

    public String getDoctype() {
        return this._doctype;
    }

    public void setStylesheet(String stylesheet) {
        this._stylesheet = stylesheet;
    }

    public String getStylesheet() {
        return this._stylesheet;
    }

    public void setTitleLocation(String titleLocation) {
        this._titleLocation = Location.getLocation(titleLocation);
    }

    public Location getTitleLocation() {
        return this._titleLocation;
    }

    public void setWindowStateMenu(Menu windowStateMenu) {
        this._windowStateMenu = windowStateMenu;
    }

    public Menu getWindowStateMenu() {
        return this._windowStateMenu;
    }

    public void setPortletModeMenu(Menu portletModeMenu) {
        this._portletModeMenu = portletModeMenu;
    }

    public Menu getPortletModeMenu() {
        return this._portletModeMenu;
    }

    public void init() {
        if (this._windowStateMenu == null) {
            this._windowStateMenu = new HtmlMenu();
        }
        if (this._portletModeMenu == null) {
            this._portletModeMenu = new HtmlMenu();
        }
    }

    protected void beginPage(PrintWriter out, RenderRequest request, String namespace) throws IOException {
        PortletPreferences pref = request.getPreferences();
        RenderResponse response = this.getRenderResponse(request);
        String stylesheet = pref.getValue(PREFERENCE_STYLESHEET, this._stylesheet);
        String pageTitle = this._pageTitle;
        if (this._doctype != null && this._doctype.length() > 0) {
            out.print("<!DOCTYPE ");
            out.print(this._doctype);
            out.print('>');
            this.printNewline(out);
        }
        out.print("<html>");
        this.printNewline(out);
        out.print("<head>");
        this.printNewline(out);
        if (pageTitle != null) {
            out.print(new CharBuffer().append("<title>").append(pageTitle).append("</title>").toString());
            this.printNewline(out);
        }
        if (stylesheet != null && stylesheet.length() > 0) {
            String cssUrl = response.encodeURL(stylesheet);
            out.print("<link rel='StyleSheet' href='");
            out.print(cssUrl);
            out.print("' type='text/css' media='all'/>");
            this.printNewline(out);
        }
        out.print("</head>");
        this.printNewline(out);
        out.print("<body>");
        this.printNewline(out);
    }

    protected void beginWindow(PrintWriter out, RenderRequest request, String namespace) throws IOException {
        ResourceBundle resourceBundle = this.getResourceBundle(request);
        out.print("<div class='portlet-frame ");
        this.printEscaped(out, request.getPortletMode().toString());
        out.print(' ');
        this.printEscaped(out, request.getWindowState().toString());
        out.print("' id='");
        out.print(namespace);
        out.print("'>");
        if (this._titleLocation == Location.FRAME) {
            this.htmlTitle(out, request, namespace, resourceBundle);
        }
        if (this._portletModeMenu.getLocation() == Location.FRAME) {
            this.htmlPortletModeMenu(out, request, namespace, resourceBundle);
        }
        if (this._windowStateMenu.getLocation() == Location.FRAME) {
            this.htmlWindowStateMenu(out, request, namespace, resourceBundle);
        }
        this.printNewline(out);
        out.print("<div class='portlet-header'>");
        this.printNewline(out);
        if (this._titleLocation == Location.HEADER) {
            this.htmlTitle(out, request, namespace, resourceBundle);
        }
        if (this._portletModeMenu.getLocation() == Location.HEADER) {
            this.htmlPortletModeMenu(out, request, namespace, resourceBundle);
        }
        if (this._windowStateMenu.getLocation() == Location.HEADER) {
            this.htmlWindowStateMenu(out, request, namespace, resourceBundle);
        }
        out.print("</div>");
        this.printNewline(out);
        out.print("<div class='portlet-content'>");
        this.printNewline(out);
    }

    protected void endWindow(PrintWriter out, RenderRequest request, String namespace) throws IOException {
        ResourceBundle resourceBundle = this.getResourceBundle(request);
        out.print("</div>");
        this.printNewline(out);
        out.print("<div class='portlet-footer'>");
        this.printNewline(out);
        if (this._titleLocation == Location.FOOTER) {
            this.htmlTitle(out, request, namespace, resourceBundle);
        }
        if (this._portletModeMenu.getLocation() == Location.FOOTER) {
            this.htmlPortletModeMenu(out, request, namespace, resourceBundle);
        }
        if (this._windowStateMenu.getLocation() == Location.FOOTER) {
            this.htmlWindowStateMenu(out, request, namespace, resourceBundle);
        }
        out.print("</div>");
        this.printNewline(out);
        out.print("</div>");
        out.print("<!-- ");
        out.print(namespace);
        out.print(" -->");
        this.printNewline(out);
    }

    protected void endPage(PrintWriter out, RenderRequest request, String namespace) throws IOException {
        out.print("</body>");
        this.printNewline(out);
        out.print("</html>");
        this.printNewline(out);
    }

    protected void printNewline(PrintWriter out) {
        if (!this._compact) {
            out.println();
        }
    }

    protected void htmlTitle(PrintWriter out, RenderRequest request, String namespace, ResourceBundle resourceBundle) throws IOException {
        String title = this.getTitle(request);
        if (title != null) {
            out.print("<h1>");
            out.print(title);
            out.print("</h1>");
        }
    }

    protected void htmlPortletModeMenu(PrintWriter out, RenderRequest request, String namespace, ResourceBundle resourceBundle) throws IOException {
        PortletMode currentPortletMode = request.getPortletMode();
        Set<PortletMode> portletModes = this.getPortletModes(request);
        Menu.MenuRenderer menuRenderer = this._portletModeMenu.createRenderer();
        Iterator<PortletMode> i$ = portletModes.iterator();
        while (i$.hasNext()) {
            PortletMode portletMode = i$.next();
            String title = portletMode.toString();
            String shortDescription = null;
            String urlString = null;
            boolean isSelected = true;
            if (!portletMode.equals((Object)currentPortletMode)) {
                isSelected = false;
                PortletURL url = this.createControlURL(request);
                try {
                    url.setPortletMode(portletMode);
                }
                catch (PortletModeException ex) {
                    throw new RuntimeException(ex);
                }
                urlString = url.toString();
            }
            if (resourceBundle != null) {
                StringBuffer key = new StringBuffer();
                key.append("portletMode.");
                key.append(portletMode.toString());
                key.append(".title");
                try {
                    title = resourceBundle.getString(key.toString());
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                key.setLength(0);
                key.append("portletMode.");
                key.append(portletMode.toString());
                key.append(".shortDescription");
                try {
                    shortDescription = resourceBundle.getString(key.toString());
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            menuRenderer.add(title, shortDescription, urlString, isSelected);
        }
        menuRenderer.print(out);
    }

    protected void htmlWindowStateMenu(PrintWriter out, RenderRequest request, String namespace, ResourceBundle resourceBundle) throws IOException {
        WindowState currentWindowState = request.getWindowState();
        Set<WindowState> windowStates = this.getWindowStates(request);
        Menu.MenuRenderer menuRenderer = this._windowStateMenu.createRenderer();
        Iterator<WindowState> i$ = windowStates.iterator();
        while (i$.hasNext()) {
            WindowState windowState = i$.next();
            String title = windowState.toString();
            String shortDescription = null;
            String urlString = null;
            boolean isSelected = true;
            if (!windowState.equals((Object)currentWindowState)) {
                isSelected = false;
                PortletURL url = this.createControlURL(request);
                try {
                    url.setWindowState(windowState);
                }
                catch (WindowStateException ex) {
                    throw new RuntimeException(ex);
                }
                urlString = url.toString();
            }
            if (resourceBundle != null) {
                StringBuffer key = new StringBuffer();
                key.append("windowState.");
                key.append(windowState.toString());
                key.append(".title");
                try {
                    title = resourceBundle.getString(key.toString());
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                key.setLength(0);
                key.append("windowState.");
                key.append(windowState.toString());
                key.append(".shortDescription");
                try {
                    shortDescription = resourceBundle.getString(key.toString());
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            menuRenderer.add(title, shortDescription, urlString, isSelected);
        }
        menuRenderer.print(out);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.alpharenderer.HtmlRenderer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

