/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.alpharenderer;

import com.caucho.portal.alpharenderer.Menu;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class HtmlMenu
extends Menu {
    private static L10N L = new L10N(HtmlMenu._resin_compat_class_0());
    protected static final Logger log = Logger.getLogger(HtmlMenu._resin_compat_class_0().getName());
    private String _cssClass;
    private boolean _showSeparators = true;
    private static Class _resin_compat_class_0;

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setShowSeparators(boolean showSeparators) {
        this._showSeparators = showSeparators;
    }

    protected void menuStart(StringBuffer buf) {
        if (this._cssClass != null) {
            buf.append("<div class='");
            buf.append(this._cssClass);
            buf.append("'>");
        } else {
            buf.append("<div>");
        }
    }

    protected void menuItem(StringBuffer buf, int count, String name, String shortDescription, String url, boolean isSelected) {
        if (this._showSeparators) {
            if (count == 1) {
                buf.append("[ ");
            } else {
                buf.append(" | ");
            }
        }
        if (isSelected) {
            buf.append("<span class='sel'");
        } else if (url == null) {
            buf.append("<span class='nosel'");
        } else {
            buf.append("<span class='unsel'");
        }
        if (url == null && shortDescription != null) {
            buf.append(" title='");
            HtmlMenu.appendEscaped(buf, shortDescription);
            buf.append("'");
        }
        buf.append('>');
        if (url != null) {
            buf.append("<a href='");
            buf.append(url);
            buf.append("'");
            if (shortDescription != null) {
                buf.append(" title='");
                HtmlMenu.appendEscaped(buf, shortDescription);
                buf.append("'");
            }
            buf.append(">");
        }
        HtmlMenu.appendEscaped(buf, name);
        if (url != null) {
            buf.append("</a>");
        }
        buf.append("</span>");
    }

    protected void menuEnd(StringBuffer buf, int count) {
        if (this._showSeparators && count > 0) {
            buf.append("]");
        }
        buf.append("</div>");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.alpharenderer.HtmlMenu");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

