/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkProxy
implements ObjectProxy,
Serializable {
    private static L10N L = new L10N(LinkProxy._resin_compat_class_0());
    protected InitialContextFactory _factory;
    protected Class _factoryClass;
    protected Hashtable<String, String> _props;
    protected String _name;
    protected String _foreignName;
    private static Class _resin_compat_class_0;

    public LinkProxy() throws NamingException {
    }

    public LinkProxy(InitialContextFactory factory, Hashtable<String, String> props, String name) throws NamingException {
        if (factory == null) {
            throw new NullPointerException();
        }
        this._factory = factory;
        this._props = props;
        this._foreignName = name;
    }

    public LinkProxy(String name) throws NamingException {
        this._foreignName = name;
    }

    public void setJndiName(String name) {
        this._name = name;
    }

    public void setName(String name) {
        this.setName(name);
    }

    public void setFactory(Class factoryClass) {
        this._factoryClass = factoryClass;
    }

    public void setJndiFactory(Class factoryClass) {
        this.setFactory(factoryClass);
    }

    public void addInitParam(InitParam initParam) {
        if (this._props == null) {
            this._props = new Hashtable();
        }
        this._props.putAll(initParam.getParameters());
    }

    public void setForeignName(String name) {
        this._foreignName = name;
    }

    @Override
    public Object createObject(Hashtable env) throws NamingException {
        Hashtable<String, String> mergeEnv;
        if (env == null || env.size() == 0) {
            mergeEnv = this._props;
        } else if (this._props == null || this._props.size() == 0) {
            mergeEnv = env;
        } else {
            mergeEnv = new Hashtable<String, String>();
            mergeEnv.putAll(this._props);
            mergeEnv.putAll(env);
        }
        Context context = this._factory != null ? this._factory.getInitialContext(mergeEnv) : new InitialContext(mergeEnv);
        if (this._foreignName != null) {
            return context.lookup(this._foreignName);
        }
        return context;
    }

    public void init() throws Exception {
        if (this._name == null) {
            throw new ConfigException(L.l("<jndi-link> configuration needs a <name>.  The <name> is the JNDI name where the context will be linked."));
        }
        Class factoryClass = this._factoryClass;
        if (factoryClass != null) {
            this._factory = (InitialContextFactory)factoryClass.newInstance();
        }
        Jndi.bindDeep(this._name, this);
    }

    public String toString() {
        return new CharBuffer().append("LinkProxy[name=").append(this._name).append(",factory=").append(this._factoryClass.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.naming.LinkProxy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

