/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.config.DynamicBean;
import com.caucho.config.DynamicItem;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.Make;
import com.caucho.make.TaskConfig;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MakeLoader
extends Loader
implements DynamicBean,
Make {
    private static final Logger log = Log.open(MakeLoader._resin_compat_class_2());
    private static final EnvironmentLocal<DynamicItem[]> _localConfig = new EnvironmentLocal();
    private static DynamicItem[] _configItems;
    private Path _path;
    private ArrayList<Dependency> _dependList = new ArrayList();
    private ArrayList<Make> _makeList = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public DynamicItem[] getDynamicConfigurationElements() {
        DynamicItem[] configItems = _localConfig.get();
        if (configItems == null) {
            ArrayList<DynamicItem> items = new ArrayList<DynamicItem>();
            items.add(new DynamicItem("javac", MakeLoader._resin_compat_class_0(), "make"));
            items.add(new DynamicItem("doclet", MakeLoader._resin_compat_class_1(), "make"));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> taskClass = Class.forName("com.caucho.ejb.doclet.EjbDocletTask", false, loader);
                items.add(new DynamicItem("ejb-doclet", taskClass, "make"));
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            configItems = items.toArray(new DynamicItem[items.size()]);
            _localConfig.set(configItems);
        }
        return configItems;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        loader.addURL(this._path);
    }

    public Path getPath(String name) {
        for (int i = 0; i < this._makeList.size(); ++i) {
            Make make = this._makeList.get(i);
            try {
                make.make();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._path.lookup(name);
    }

    public void addTask(TaskConfig task) {
        Object obj = task.getTask();
        if (obj instanceof Make) {
            this._makeList.add((Make)obj);
        }
    }

    public void addMake(Make make) {
        this._makeList.add(make);
    }

    public void make() throws Exception {
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!head.equals("")) {
            cb.append(head);
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        if (this._path instanceof JarPath) {
            cb.append(((JarPath)this._path).getContainer().getNativePath());
        } else if (this._path.isDirectory()) {
            cb.append(this._path.getNativePath());
        }
        return cb.toString();
    }

    public String toString() {
        return new CharBuffer().append("MakeLoader[").append(this._path).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.make.task.JavacTask");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.make.task.DocletTask");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.make.MakeLoader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

