/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CharBuffer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

class EnvironmentLogger
extends Logger
implements ClassLoaderListener {
    private final EnvironmentLocal<Logger> _localLoggers = new EnvironmentLocal();
    private final EnvironmentLocal<Handler[]> _localHandlers = new EnvironmentLocal();
    private final EnvironmentLocal<HandlerEntry> _ownHandlers = new EnvironmentLocal();
    private final EnvironmentLocal<Boolean> _useParentHandlers = new EnvironmentLocal();
    private boolean _hasLocalLevel;
    private final EnvironmentLocal<Level> _localLevel = new EnvironmentLocal();
    private Logger _parent;
    private int _level = Level.OFF.intValue();
    private final ArrayList<SoftReference<EnvironmentLogger>> _children = new ArrayList();
    private final ArrayList<SoftReference<ClassLoader>> _loaders = new ArrayList();

    public EnvironmentLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.doSetLevel(Level.OFF);
    }

    public void setParent(Logger parent) {
        if (parent.equals(this._parent)) {
            return;
        }
        super.setParent(parent);
        this._parent = parent;
        this.doSetLevel(parent.getLevel());
        if (parent instanceof EnvironmentLogger) {
            EnvironmentLogger envParent = (EnvironmentLogger)parent;
            envParent.addChild(this);
        }
    }

    void addChild(EnvironmentLogger child) {
        this._children.add(new SoftReference<EnvironmentLogger>(child));
    }

    public synchronized void addHandler(Handler handler) {
        HandlerEntry ownHandlers;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean hasLoader = false;
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            SoftReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (refLoader == loader) {
                hasLoader = true;
            }
            if (!this.isParentLoader(loader, refLoader)) continue;
            this.addHandler(handler, refLoader);
        }
        if (!hasLoader) {
            this._loaders.add(new SoftReference<ClassLoader>(loader));
            this.addHandler(handler, loader);
            Environment.addClassLoaderListener(this, loader);
        }
        if ((ownHandlers = this._ownHandlers.get()) == null) {
            ownHandlers = new HandlerEntry(this);
            this._ownHandlers.set(ownHandlers);
        }
        ownHandlers.addHandler(handler);
    }

    private void addHandler(Handler handler, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        handlers.add(handler);
        for (ClassLoader ptr = loader; ptr != null; ptr = ptr.getParent()) {
            Handler[] localHandlers = this._localHandlers.getLevel(ptr);
            if (localHandlers == null) continue;
            for (int i = 0; i < localHandlers.length; ++i) {
                int p = handlers.indexOf(localHandlers[i]);
                if (p < 0) {
                    handlers.add(localHandlers[i]);
                    continue;
                }
                Handler oldHandler = (Handler)handlers.get(p);
                if (localHandlers[i].getLevel().intValue() >= oldHandler.getLevel().intValue()) continue;
                handlers.set(p, localHandlers[i]);
            }
        }
        Handler[] newHandlers = new Handler[handlers.size()];
        handlers.toArray(newHandlers);
        this._localHandlers.set(newHandlers);
        if (handler.getLevel().intValue() < this._level) {
            this.doSetLevel(handler.getLevel());
        }
    }

    public synchronized void removeHandler(Handler handler) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean hasLoader = false;
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            SoftReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (!this.isParentLoader(loader, refLoader)) continue;
            this.removeHandler(handler, refLoader);
        }
        HandlerEntry ownHandlers = this._ownHandlers.get();
        if (ownHandlers != null) {
            ownHandlers.removeHandler(handler);
        }
    }

    private void removeHandler(Handler handler, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (ClassLoader ptr = loader; ptr != null; ptr = ptr.getParent()) {
            Handler[] localHandlers = this._localHandlers.getLevel(ptr);
            if (localHandlers == null) continue;
            for (int i = 0; i < localHandlers.length; ++i) {
                if (localHandlers[i].equals(handler)) continue;
                int p = handlers.indexOf(localHandlers[i]);
                if (p < 0) {
                    handlers.add(localHandlers[i]);
                    continue;
                }
                Handler oldHandler = (Handler)handlers.get(p);
                if (localHandlers[i].getLevel().intValue() >= oldHandler.getLevel().intValue()) continue;
                handlers.set(p, localHandlers[i]);
            }
        }
        Handler[] newHandlers = new Handler[handlers.size()];
        handlers.toArray(newHandlers);
        this._localHandlers.set(newHandlers);
        if (handler.getLevel().intValue() < this._level) {
            this.doSetLevel(handler.getLevel());
        }
    }

    private boolean isParentLoader(ClassLoader parent, ClassLoader child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    boolean addLogger(Logger logger) {
        if (logger.getClass().getName().startsWith("java")) {
            return false;
        }
        Logger oldLogger = this._localLoggers.get();
        if (oldLogger != null) {
            return false;
        }
        this._localLoggers.set(logger);
        return true;
    }

    Logger getLogger() {
        return this._localLoggers.get();
    }

    public Handler[] getHandlers() {
        return this._localHandlers.get();
    }

    public boolean getUseParentHandlers() {
        Boolean value = this._useParentHandlers.get();
        if (value == null) {
            return super.getUseParentHandlers();
        }
        return Boolean.TRUE.equals(value);
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this._useParentHandlers.set(new Boolean(useParentHandlers));
    }

    public void classLoaderInit(DynamicClassLoader env) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.removeLoader(loader);
        this._localHandlers.remove(loader);
        HandlerEntry ownHandlers = this._ownHandlers.getLevel(loader);
        if (ownHandlers != null) {
            this._ownHandlers.remove(loader);
        }
        if (ownHandlers != null) {
            ownHandlers.destroy();
        }
        this._localLevel.remove(loader);
        this.updateLevel();
    }

    private synchronized void updateLevel() {
        SoftReference<Object> ref;
        int i;
        int oldLevel = this._level;
        Level level = Level.OFF;
        boolean hasLocalLevel = false;
        if (this._parent != null && this._parent.getLevel().intValue() < level.intValue()) {
            level = this._parent.getLevel();
        }
        for (i = this._loaders.size() - 1; i >= 0; --i) {
            ref = this._loaders.get(i);
            ClassLoader loader = ref.get();
            if (loader == null) {
                this._loaders.remove(i);
            }
            while (loader != null) {
                if (loader instanceof EnvironmentClassLoader) {
                    EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                    if (this._localLevel.get(envLoader) != null) {
                        hasLocalLevel = true;
                    }
                    Handler[] handlers = this._localHandlers.getLevel(envLoader);
                    for (int j = 0; handlers != null && j < handlers.length; ++j) {
                        Level handlerLevel = Level.INFO;
                        if (handlers[j].getLevel() != null) {
                            handlerLevel = handlers[j].getLevel();
                        }
                        if (handlerLevel.intValue() >= level.intValue()) continue;
                        level = handlerLevel;
                    }
                }
                loader = loader.getParent();
            }
        }
        this.doSetLevel(level);
        this._hasLocalLevel = hasLocalLevel;
        if (oldLevel < level.intValue()) {
            for (i = this._children.size() - 1; i >= 0; --i) {
                ref = this._children.get(i);
                EnvironmentLogger child = (EnvironmentLogger)ref.get();
                if (child != null) {
                    child.updateLevel();
                    continue;
                }
                this._children.remove(i);
            }
        }
    }

    public void setLevel(Level level) {
        this._hasLocalLevel = true;
        this._localLevel.set(level);
        this.doSetLevel(level);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean hasLoader = false;
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            SoftReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (refLoader != loader) continue;
            return;
        }
        this._loaders.add(new SoftReference<ClassLoader>(loader));
        Environment.addClassLoaderListener(this, loader);
    }

    public Level getLevel() {
        Level level;
        if (this._hasLocalLevel && (level = this._localLevel.get()) != null) {
            return level;
        }
        return super.getLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetLevel(Level level) {
        super.setLevel(level);
        this._level = this.getLevel().intValue();
        EnvironmentLogger environmentLogger = this;
        synchronized (environmentLogger) {
            for (int i = this._children.size() - 1; i >= 0; --i) {
                SoftReference<EnvironmentLogger> ref = this._children.get(i);
                EnvironmentLogger child = ref.get();
                if (child != null) {
                    if (this._level >= child._level) continue;
                    child.doSetLevel(level);
                    continue;
                }
                this._children.remove(i);
            }
        }
    }

    private synchronized void removeLoader(ClassLoader loader) {
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            SoftReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
                continue;
            }
            if (refLoader != loader) continue;
            this._loaders.remove(i);
        }
    }

    public String toString() {
        return new CharBuffer().append("EnvironmentLogger[").append(this.getName()).append("]").toString();
    }

    static class HandlerEntry {
        private final EnvironmentLogger _logger;
        private ArrayList<Handler> _handlers = new ArrayList();

        HandlerEntry(EnvironmentLogger logger) {
            this._logger = logger;
        }

        void addHandler(Handler handler) {
            this._handlers.add(handler);
        }

        void removeHandler(Handler handler) {
            this._handlers.remove(handler);
        }

        void destroy() {
            ArrayList<Handler> handlers = this._handlers;
            this._handlers = null;
            for (int i = 0; handlers != null && i < handlers.size(); ++i) {
                Handler handler = handlers.get(i);
                try {
                    handler.close();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

