/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnhancerPrepare {
    private static final L10N L = new L10N(EnhancerPrepare._resin_compat_class_0());
    private static final Logger log = Logger.getLogger(EnhancerPrepare._resin_compat_class_0().getName());
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private JavaClassGenerator _javaGen = new JavaClassGenerator();
    private ClassLoader _loader;
    private Path _workPath;
    private ArrayList<ClassEnhancer> _enhancerList = new ArrayList();
    private String _baseSuffix = "";
    private String _extSuffix = "__ResinExt";
    private boolean _isParentStarted;
    private static Class _resin_compat_class_0;

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir(this._loader);
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public void addEnhancer(ClassEnhancer enhancer) {
        this._enhancerList.add(enhancer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameClass(String sourceClass, String targetClass) {
        Path source = this.getSource(sourceClass);
        if (source == null || source.getLastModified() <= 0L) {
            return;
        }
        Path path = this.getPreWorkPath();
        Path target = path.lookup(new CharBuffer().append(targetClass.replace('.', '/')).append(".class").toString());
        if (target.getLastModified() <= 0L || target.getLastModified() < source.getLastModified()) {
            try {
                target.remove();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                ByteCodeParser parser = new ByteCodeParser();
                ReadStream is = source.openRead();
                WriteStream os = null;
                try {
                    int i;
                    JavaClass cl = parser.parse(is);
                    String cpOldName = sourceClass.replace('.', '/');
                    String cpClassName = targetClass.replace('.', '/');
                    int utf8Index = cl.getConstantPool().addUTF8(cpClassName).getIndex();
                    cl.getConstantPool().getClass(cpOldName).setNameIndex(utf8Index);
                    cl.setThisClass(cpClassName);
                    ArrayList<JavaField> fields = cl.getFieldList();
                    for (int i2 = 0; i2 < fields.size(); ++i2) {
                        JavaField field = fields.get(i2);
                        int accessFlags = field.getAccessFlags();
                        if ((accessFlags & 2) == 0) continue;
                        accessFlags = accessFlags & 0xFFFFFFFD | 4;
                        field.setAccessFlags(accessFlags);
                    }
                    ArrayList<JavaMethod> methods = cl.getMethodList();
                    for (i = 0; i < methods.size(); ++i) {
                        JavaMethod method = methods.get(i);
                        int accessFlags = method.getAccessFlags();
                        if ((accessFlags & 2) == 0) continue;
                        accessFlags = accessFlags & 0xFFFFFFFD | 4;
                        method.setAccessFlags(accessFlags);
                    }
                    for (i = 0; i < this._enhancerList.size(); ++i) {
                        this._enhancerList.get(i).preEnhance(cl);
                    }
                    target.getParent().mkdirs();
                    os = target.openWrite();
                    cl.write(os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    private Path getSource(String className) {
        URL url;
        ClassLoader loader = this._loader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((url = loader.getResource(new CharBuffer().append(className.replace('.', '/')).append(".class").toString())) != null) {
            return Vfs.lookup(url.toString());
        }
        return null;
    }

    protected JavaClass renameClass(JavaClass jClass, String targetClass) {
        String cpOldName = jClass.getThisClass();
        String cpClassName = targetClass.replace('.', '/');
        int utf8Index = jClass.getConstantPool().addUTF8(cpClassName).getIndex();
        jClass.getConstantPool().getClass(cpOldName).setNameIndex(utf8Index);
        jClass.setThisClass(cpClassName);
        ArrayList<JavaField> fields = jClass.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            JavaField field = fields.get(i);
            int accessFlags = field.getAccessFlags();
            if ((accessFlags & 2) == 0) continue;
            accessFlags = accessFlags & 0xFFFFFFFD | 4;
            field.setAccessFlags(accessFlags);
        }
        ArrayList<JavaMethod> methods = jClass.getMethodList();
        for (int i = 0; i < methods.size(); ++i) {
            JavaMethod method = methods.get(i);
            int accessFlags = method.getAccessFlags();
            if ((accessFlags & 2) == 0) continue;
            accessFlags = accessFlags & 0xFFFFFFFD | 4;
            method.setAccessFlags(accessFlags);
        }
        return jClass;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.enhancer.EnhancerPrepare");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

