/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.ByteCodeClassMatcher;
import com.caucho.bytecode.ByteCodeClassScanner;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.ByteCodeEnhancer;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.loader.enhancer.ClassEnhancerConfig;
import com.caucho.loader.enhancer.EnhancerFixup;
import com.caucho.loader.enhancer.EnhancerPrepare;
import com.caucho.loader.enhancer.EnhancerRuntimeException;
import com.caucho.loader.enhancer.MethodEnhancer;
import com.caucho.loader.enhancer.MethodEnhancerConfig;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnhancerManager
implements ByteCodeEnhancer,
ByteCodeClassMatcher {
    private static final L10N L = new L10N(EnhancerManager._resin_compat_class_0());
    private static final Logger log = Log.open(EnhancerManager._resin_compat_class_0());
    private static EnvironmentLocal<EnhancerManager> _localEnhancer = new EnvironmentLocal();
    private EnhancerManager _parent;
    private DynamicClassLoader _loader;
    private Path _workPath;
    private JavaClassLoader _jClassLoader = new JavaClassLoader();
    private JavaClassGenerator _javaGen = new JavaClassGenerator();
    private ArrayList<ClassEnhancer> _classEnhancerList = new ArrayList();
    private HashMap<CharBuffer, MethodEnhancer> _methodEnhancerMap = new HashMap();
    private static Class _resin_compat_class_0;

    private EnhancerManager(ClassLoader loader) {
        while (loader != null && !(loader instanceof DynamicClassLoader)) {
            loader = loader.getParent();
        }
        this._loader = (DynamicClassLoader)loader;
        if (loader != null) {
            this._parent = EnhancerManager.getLocalEnhancer(loader.getParent());
        }
        if (this._parent != null) {
            this._classEnhancerList.addAll(this._parent._classEnhancerList);
            this._methodEnhancerMap.putAll(this._parent._methodEnhancerMap);
        }
    }

    public static EnhancerManager create() {
        return EnhancerManager.create(Thread.currentThread().getContextClassLoader());
    }

    public static EnhancerManager create(ClassLoader loader) {
        EnhancerManager enhancer = _localEnhancer.getLevel(loader);
        if (enhancer == null) {
            enhancer = new EnhancerManager(loader);
            _localEnhancer.set(enhancer, loader);
            while (loader != null) {
                if (loader instanceof DynamicClassLoader) {
                    ((DynamicClassLoader)loader).setByteCodeEnhancer(enhancer);
                    break;
                }
                loader = loader.getParent();
            }
        }
        return enhancer;
    }

    public static EnhancerManager getLocalEnhancer(ClassLoader loader) {
        return _localEnhancer.get(loader);
    }

    public JavaClassLoader getJavaClassLoader() {
        return this._jClassLoader;
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir(this._loader);
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public void addClassEnhancer(ClassEnhancer classEnhancer) {
        this._classEnhancerList.add(classEnhancer);
    }

    public void addMethod(MethodEnhancerConfig config) {
        config.setEnhancerManager(this);
        CharBuffer name = new CharBuffer(config.getAnnotation().getName());
        this._methodEnhancerMap.put(name, config);
    }

    public void addClass(ClassEnhancerConfig config) {
        config.setEnhancerManager(this);
        this._classEnhancerList.add(config);
    }

    public byte[] enhance(String className, byte[] buffer, int offset, int length) {
        ByteCodeClassScanner scanner = new ByteCodeClassScanner(className, buffer, offset, length, this);
        if (scanner.scan()) {
            try {
                ByteCodeParser parser = new ByteCodeParser();
                parser.setClassLoader(this._jClassLoader);
                ByteArrayInputStream is = new ByteArrayInputStream(buffer, offset, length);
                JavaClass jClass = parser.parse(is);
                return this.enhance(jClass);
            }
            catch (Throwable e) {
                throw new EnhancerRuntimeException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] enhance(JClass jClass) throws ClassNotFoundException {
        String className = jClass.getName().replace('/', '.');
        String extClassName = new CharBuffer().append(className).append("__ResinExt").toString();
        try {
            EnhancerPrepare prepare = new EnhancerPrepare();
            prepare.setWorkPath(this.getWorkPath());
            prepare.setClassLoader(this._loader);
            Iterator<ClassEnhancer> i$ = this._classEnhancerList.iterator();
            while (i$.hasNext()) {
                ClassEnhancer enhancer = i$.next();
                if (!enhancer.shouldEnhance(className)) continue;
                prepare.addEnhancer(enhancer);
            }
            prepare.renameClass(className, className);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(e.toString());
        }
        boolean hasEnhancer = false;
        GenClass genClass = new GenClass(extClassName);
        genClass.setSuperClassName(className);
        Iterator<ClassEnhancer> i$ = this._classEnhancerList.iterator();
        while (i$.hasNext()) {
            ClassEnhancer enhancer = i$.next();
            if (!enhancer.shouldEnhance(className)) continue;
            try {
                hasEnhancer = true;
                enhancer.enhance(genClass, jClass, extClassName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        JMethod[] arr$ = jClass.getDeclaredMethods();
        int len$ = arr$.length;
        for (int i$2 = 0; i$2 < len$; ++i$2) {
            JMethod jMethod = arr$[i$2];
            JAnnotation[] arr$2 = jMethod.getDeclaredAnnotations();
            int len$2 = arr$2.length;
            for (int i$3 = 0; i$3 < len$2; ++i$3) {
                JAnnotation jAnn = arr$2[i$3];
                String type = jAnn.getType();
                CharBuffer cb = new CharBuffer(type = type.replace('/', '.'));
                MethodEnhancer enhancer = this._methodEnhancerMap.get(cb);
                if (enhancer == null) continue;
                hasEnhancer = true;
                enhancer.enhance(genClass, jMethod, jAnn);
            }
        }
        try {
            if (hasEnhancer) {
                this._javaGen.setWorkDir(this.getPreWorkPath());
                this._javaGen.generate(genClass);
                this._javaGen.compilePendingJava();
            }
            EnhancerFixup fixup = new EnhancerFixup();
            fixup.setJavaClassLoader(this._jClassLoader);
            fixup.setClassLoader(this._loader);
            fixup.setWorkPath(this.getWorkPath());
            Iterator<ClassEnhancer> i$4 = this._classEnhancerList.iterator();
            while (i$4.hasNext()) {
                ClassEnhancer enhancer = i$4.next();
                if (!enhancer.shouldEnhance(className)) continue;
                fixup.addEnhancer(enhancer);
            }
            fixup.fixup(className, extClassName);
            Path path = this.getPostWorkPath().lookup(new CharBuffer().append(className.replace('.', '/')).append(".class").toString());
            byte[] buffer = new byte[(int)path.getLength()];
            ReadStream is = path.openRead();
            try {
                is.readAll(buffer, 0, buffer.length);
            }
            finally {
                is.close();
            }
            return buffer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    public boolean isClassMatch(String className) {
        int p;
        char ch;
        if (className.lastIndexOf(36) >= 0 ? (ch = className.charAt((p = className.lastIndexOf(36)) + 1)) >= '0' && ch <= '9' : className.indexOf(43) > 0 || className.indexOf(45) > 0) {
            return false;
        }
        for (int i = 0; i < this._classEnhancerList.size(); ++i) {
            if (!this._classEnhancerList.get(i).shouldEnhance(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatch(CharBuffer cb) {
        return this._methodEnhancerMap.get(cb) != null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.enhancer.EnhancerManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

