/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakStopListener
implements EnvironmentListener {
    private static final L10N L = new L10N(WeakStopListener._resin_compat_class_0());
    private static final Logger log = Log.open(WeakStopListener._resin_compat_class_0());
    private WeakReference<Object> _resourceRef;
    private static Class _resin_compat_class_0;

    public WeakStopListener(Object resource) {
        this._resourceRef = new WeakReference<Object>(resource);
    }

    public void environmentStart(EnvironmentClassLoader loader) {
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        Object resource = this._resourceRef.get();
        if (resource == null) {
            return;
        }
        Method destroy = WeakStopListener.getStopMethod(resource.getClass());
        if (destroy == null) {
            return;
        }
        try {
            destroy.invoke(resource, (Object[])null);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public static Method getStopMethod(Class cl) {
        try {
            return cl.getMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.WeakStopListener");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

