/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.CloseListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakCloseListener
implements ClassLoaderListener {
    private static final L10N L = new L10N(WeakCloseListener._resin_compat_class_0());
    private static final Logger log = Log.open(WeakCloseListener._resin_compat_class_0());
    private WeakReference<Object> _resourceRef;
    private static Class _resin_compat_class_0;

    public WeakCloseListener(Object resource) {
        this._resourceRef = new WeakReference<Object>(resource);
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        Object resource = this._resourceRef.get();
        if (resource == null) {
            return;
        }
        Method destroy = CloseListener.getDestroyMethod(resource.getClass());
        if (destroy == null) {
            return;
        }
        try {
            destroy.invoke(resource, (Object[])null);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.CloseListener");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

