/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.DependencyContainer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

public class TreeLoader
extends Loader
implements Dependency {
    private static final Logger log = Log.open(TreeLoader._resin_compat_class_0());
    private Path _dir;
    private long _lastModified;
    private String[] _fileNames;
    private ArrayList<JarEntry> _jarList;
    private HashSet<Path> _files = new HashSet();
    private HashSet<Path> _tempFiles = new HashSet();
    private DependencyContainer _dependencyList = new DependencyContainer();
    private static Class _resin_compat_class_0;

    public TreeLoader() {
    }

    public TreeLoader(Path dir) {
        this._dir = dir;
        this.init();
    }

    public void setPath(Path path) {
        this._dir = path;
    }

    public Path getPath() {
        return this._dir;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path dir) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        TreeLoader treeLoader = new TreeLoader(dir);
        loader.addLoader(treeLoader);
        loader.init();
        return loader;
    }

    public void init() {
        this._lastModified = this._dir.getLastModified();
        try {
            this._fileNames = this._dir.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._jarList = new ArrayList();
        this._dependencyList = new DependencyContainer();
        this.fillJars();
    }

    public boolean isModified() {
        return this._dependencyList.isModified();
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        for (int i = 0; i < this._jarList.size(); ++i) {
            loader.addURL(this._jarList.get(i).getJarPath());
        }
    }

    private void fillJars() {
        this.clearJars();
        this.fillJars(this._dir);
    }

    private void fillJars(Path dir) {
        try {
            String[] list = dir.list();
            for (int j = 0; list != null && j < list.length; ++j) {
                Path path = dir.lookup(list[j]);
                if (list[j].endsWith(".jar") || list[j].endsWith(".zip")) {
                    this.addJar(path);
                    continue;
                }
                if (!path.isDirectory()) continue;
                this.fillJars(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addJar(Path jar) {
        JarPath jarPath = JarPath.create(jar);
        JarEntry jarEntry = new JarEntry(jarPath);
        if (this._jarList.contains(jarEntry)) {
            return;
        }
        this._jarList.add(jarEntry);
        this._dependencyList.add(jarPath.getDepend());
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        cb.append(head);
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(jar.getContainer().getNativePath());
        }
        return cb.close();
    }

    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/');
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        pathName = new CharBuffer().append(pathName).append(".class").toString();
        Object classPath = null;
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead() || filePath.getLength() <= 0L) continue;
            ClassEntry entry = new ClassEntry(this.getLoader(), name, filePath, filePath, this.getCodeSource(filePath));
            ClassPackage classPackage = jarEntry.getPackage(pkg);
            entry.setClassPackage(classPackage);
            return entry;
        }
        return null;
    }

    public Path getPath(String pathName) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead()) continue;
            return filePath;
        }
        return null;
    }

    public Path getCodePath() {
        return this._dir;
    }

    protected void destroy() {
        this.clearJars();
    }

    private void clearJars() {
        ArrayList<JarEntry> jars = new ArrayList<JarEntry>(this._jarList);
        this._jarList.clear();
        for (int i = 0; i < jars.size(); ++i) {
            JarEntry jarEntry = jars.get(i);
            JarPath jarPath = jarEntry.getJarPath();
            jarPath.closeJar();
        }
    }

    public String toString() {
        return new CharBuffer().append("TreeLoader[").append(this._dir).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.TreeLoader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

