/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Loader {
    protected static final Logger log = Log.open(Loader._resin_compat_class_0());
    private DynamicClassLoader _loader;
    private static Class _resin_compat_class_0;

    public void setLoader(DynamicClassLoader loader) {
        this._loader = loader;
    }

    public DynamicClassLoader getLoader() {
        return this._loader;
    }

    public void validate() throws ConfigException {
    }

    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = new CharBuffer().append(name.replace('.', '/')).append(".class").toString();
        Path path = this.getPath(pathName);
        if (path != null && path.getLength() > 0L) {
            return new ClassEntry(this._loader, name, path, path, this.getCodeSource(path));
        }
        return null;
    }

    public URL getResource(String name) {
        Path path = name.startsWith("/") ? this.getPath(new CharBuffer().append(".").append(name).toString()) : this.getPath(name);
        if (path != null && path.exists()) {
            try {
                return new URL(path.getURL());
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return null;
    }

    public void getResources(Vector<URL> resources, String name) {
        Path path = name.startsWith("/") ? this.getPath(new CharBuffer().append(".").append(name).toString()) : this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                resources.add(new URL(path.getURL()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        Path path = name.startsWith("/") ? this.getPath(new CharBuffer().append(".").append(name).toString()) : this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                return path.openRead();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Path getPath(String name) {
        return null;
    }

    protected CodeSource getCodeSource(Path path) {
        try {
            return new CodeSource(new URL(path.getURL()), (Certificate[])null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    protected String getClassPath(String head) {
        return head;
    }

    protected String getSourcePath(String head) {
        return this.getClassPath(head);
    }

    protected void destroy() {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.Loader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

