/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassPackage;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class JarEntry {
    private static final L10N L = new L10N(JarEntry._resin_compat_class_0());
    private static final Logger log = Log.open(JarEntry._resin_compat_class_0());
    private Manifest _manifest;
    private JarPath _jarPath;
    private ArrayList<ClassPackage> _packages = new ArrayList();
    private CodeSource _codeSource;
    private static Class _resin_compat_class_0;

    JarEntry(JarPath jarPath) {
        this._jarPath = jarPath;
        try {
            this._codeSource = new CodeSource(new URL(jarPath.getURL()), (Certificate[])null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this.readManifest();
    }

    private void readManifest() {
        try {
            this._manifest = this._jarPath.getManifest();
            if (this._manifest == null) {
                return;
            }
            Attributes attr = this._manifest.getMainAttributes();
            if (attr != null) {
                this.addManifestPackage("", attr);
            }
            Map<String, Attributes> entries = this._manifest.getEntries();
            Iterator<String> iter = entries.keySet().iterator();
            while (iter.hasNext()) {
                String pkg = iter.next();
                attr = this._manifest.getAttributes(pkg);
                if (attr == null) continue;
                this.addManifestPackage(pkg, attr);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void addManifestPackage(String name, Attributes attr) {
        if (!name.endsWith("/") && !name.equals("")) {
            return;
        }
        String specTitle = attr.getValue("Specification-Title");
        String specVersion = attr.getValue("Specification-Version");
        String specVendor = attr.getValue("Specification-Vendor");
        String implTitle = attr.getValue("Implementation-Title");
        String implVersion = attr.getValue("Implementation-Version");
        String implVendor = attr.getValue("Implementation-Vendor");
        if (specTitle == null && specVersion == null && specVendor != null && implTitle == null && implVersion == null && implVendor != null) {
            return;
        }
        ClassPackage pkg = new ClassPackage(name);
        pkg.setSpecificationTitle(specTitle);
        pkg.setSpecificationVersion(specVersion);
        pkg.setSpecificationVendor(specVendor);
        pkg.setImplementationTitle(implTitle);
        pkg.setImplementationVersion(implVersion);
        pkg.setImplementationVendor(implVendor);
        this._packages.add(pkg);
    }

    public void validate() throws ConfigException {
        if (this._manifest != null) {
            JarEntry.validateManifest(this._jarPath.getContainer().getURL(), this._manifest);
        }
    }

    public static void validateManifest(String manifestName, Manifest manifest) throws ConfigException {
        Attributes attr = manifest.getMainAttributes();
        if (attr == null) {
            return;
        }
        String extList = attr.getValue("Extension-List");
        if (extList == null) {
            return;
        }
        Pattern pattern = Pattern.compile("[, \t]+");
        String[] split = pattern.split(extList);
        for (int i = 0; i < split.length; ++i) {
            String ext = split[i];
            String name = attr.getValue(new CharBuffer().append(ext).append("-Extension-Name").toString());
            if (name == null) continue;
            Package pkg = Package.getPackage(name);
            if (pkg == null) {
                log.warning(L.l("package {0} is missing.  {1} requires package {0}.", (Object)name, manifestName));
                continue;
            }
            String version = attr.getValue(new CharBuffer().append(ext).append("-Specification-Version").toString());
            if (version == null) continue;
            if (pkg.getSpecificationVersion() == null || pkg.getSpecificationVersion().equals("")) {
                log.warning(L.l("installed {0} is not compatible with version `{1}'.  {2} requires version {1}.", name, version, manifestName));
                continue;
            }
            if (pkg.isCompatibleWith(version)) continue;
            log.warning(L.l("installed {0} is not compatible with version `{1}'.  {2} requires version {1}.", name, version, manifestName));
        }
    }

    public ClassPackage getPackage(String name) {
        ClassPackage bestPackage = null;
        int bestLength = -1;
        for (int i = 0; i < this._packages.size(); ++i) {
            ClassPackage pkg = this._packages.get(i);
            String prefix = pkg.getPrefix();
            if (!name.startsWith(prefix) || bestLength >= prefix.length()) continue;
            bestPackage = pkg;
            bestLength = prefix.length();
        }
        return bestPackage;
    }

    public JarPath getJarPath() {
        return this._jarPath;
    }

    public CodeSource getCodeSource() {
        return this._codeSource;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JarEntry)) {
            return false;
        }
        JarEntry entry = (JarEntry)o;
        return this._jarPath.equals(entry._jarPath);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.JarEntry");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

