/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QDocument;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTransformTag
extends BodyTagSupport
implements NameValueTag {
    private static final Logger log = Log.open(XmlTransformTag._resin_compat_class_0());
    private static final L10N L = new L10N(XmlTransformTag._resin_compat_class_0());
    private Object _xml;
    private Object _xslt;
    private String _xmlSystemId;
    private String _xsltSystemId;
    private String _var;
    private String _scope;
    private Object _result;
    private ArrayList<String> _paramNames = new ArrayList();
    private ArrayList<String> _paramValues = new ArrayList();
    private static Class _resin_compat_class_0;

    public void setDoc(Object xml) {
        this._xml = xml;
    }

    public void setXml(Object xml) {
        this.setDoc(xml);
    }

    public void setXslt(Object xslt) {
        this._xslt = xslt;
    }

    public void setXmlSystemId(String xmlSystemId) {
        this._xmlSystemId = xmlSystemId;
    }

    public void setDocSystemId(String docSystemId) {
        this._xmlSystemId = docSystemId;
    }

    public void setXsltSystemId(String xsltSystemId) {
        this._xsltSystemId = xsltSystemId;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setResult(Object result) {
        this._result = result;
    }

    public void addParam(String name, String value) {
        this._paramNames.add(name);
        this._paramValues.add(value);
    }

    public int doStartTag() throws JspException {
        this._paramNames.clear();
        this._paramValues.clear();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        try {
            Result result;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            JspWriter out = pageContext.getOut();
            TransformerFactory factory = TransformerFactory.newInstance();
            String xsltSystemId = this.getCanonicalURL(pageContext, this._xsltSystemId);
            Source source = this.getSource(this._xslt, xsltSystemId);
            Transformer transformer = factory.newTransformer(source);
            for (int i = 0; i < this._paramNames.size(); ++i) {
                String name = this._paramNames.get(i);
                String value = this._paramValues.get(i);
                transformer.setParameter(name, value);
            }
            if (this._xml != null) {
                source = this.getSource(this._xml, this.getCanonicalURL(pageContext, this._xmlSystemId));
            } else {
                BodyContent bodyContent = this.getBodyContent();
                source = new StreamSource(bodyContent.getReader());
                if (this._xmlSystemId != null) {
                    source.setSystemId(this.getCanonicalURL(pageContext, this._xmlSystemId));
                } else {
                    source.setSystemId(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
                }
            }
            QDocument top = null;
            if (this._result != null) {
                result = (Result)this._result;
            } else if (this._var != null) {
                top = new QDocument();
                result = new DOMResult(top);
            } else {
                result = new StreamResult((Writer)out);
            }
            transformer.transform(source, result);
            if (this._var != null) {
                CoreSetTag.setValue(pageContext, this._var, this._scope, top);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private Source getSource(Object xml, String systemId) throws JspException {
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        Object xmlObj = xml;
        Source source = null;
        if (xmlObj instanceof String) {
            ReadStream is = Vfs.openString((String)xmlObj);
            source = new StreamSource(is, systemId);
        } else if (xmlObj instanceof InputStream) {
            source = new StreamSource((InputStream)xmlObj, systemId);
        } else if (xmlObj instanceof Reader) {
            source = new StreamSource((Reader)xmlObj, systemId);
        } else if (xmlObj instanceof Node) {
            source = new DOMSource((Node)xmlObj, systemId);
        } else if (xmlObj instanceof NodeList) {
            source = new DOMSource(((NodeList)xmlObj).item(0), systemId);
        } else if (xmlObj instanceof Source) {
            source = (Source)xmlObj;
        } else {
            throw new JspException(L.l("unknown xml object type `{0}'", xmlObj));
        }
        return source;
    }

    private String getCanonicalURL(PageContextImpl pageContext, String url) {
        Application app = pageContext.getApplication();
        Path appDir = pageContext.getApplication().getAppDir();
        if (url != null) {
            if (url.startsWith("/")) {
                url = app.getRealPath(url);
            } else if (url.indexOf(58) <= 0 || url.indexOf(58) >= url.indexOf(47)) {
                url = pageContext.getRequest().getRealPath(url);
            }
            url = appDir.lookup(url).getURL();
        }
        return url;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jstl.rt.XmlTransformTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

