/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.L10N;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class FmtParseNumberTag
extends BodyTagSupport {
    private static L10N L = new L10N(FmtParseNumberTag._resin_compat_class_0());
    private String _value;
    private String _type;
    private String _pattern;
    private Object _parseLocale;
    private boolean _integerOnly = false;
    private String _var;
    private String _scope;
    private static Class _resin_compat_class_0;

    public void setValue(String value) {
        this._value = value;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public void setParseLocale(Object locale) {
        this._parseLocale = locale;
    }

    public void setIntegerOnly(boolean integerOnly) {
        this._integerOnly = integerOnly;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doEndTag() throws JspException {
        try {
            PageContextImpl pc = (PageContextImpl)this.pageContext;
            JspWriter out = pc.getOut();
            NumberFormat format = this.getFormat();
            String string = this._value != null ? this._value : this.bodyContent.getString().trim();
            Number value = format.parse(string);
            if (this._var == null) {
                out.print((Object)value);
            } else {
                CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException e) {
        }
        catch (ParseException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    protected NumberFormat getFormat() throws JspException {
        PageContextImpl pc = (PageContextImpl)this.pageContext;
        NumberFormat format = null;
        Locale locale = null;
        if (this._parseLocale != null) {
            Object localeObj = this._parseLocale;
            if (localeObj instanceof Locale) {
                locale = (Locale)localeObj;
            } else if (localeObj instanceof String) {
                locale = PageContextImpl.getLocale((String)localeObj, null);
            }
        }
        if (locale == null) {
            locale = pc.getLocale();
        }
        if (this._type == null || this._type.equals("") || this._type.equals("number")) {
            format = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
            DecimalFormat decimalFormat = (DecimalFormat)format;
            if (this._pattern != null) {
                decimalFormat.applyPattern(this._pattern);
            }
        } else if (this._type.equals("percent")) {
            format = locale != null ? NumberFormat.getPercentInstance(locale) : NumberFormat.getPercentInstance();
        } else if (this._type.equals("currency")) {
            format = locale != null ? NumberFormat.getCurrencyInstance(locale) : NumberFormat.getCurrencyInstance(locale);
        } else {
            throw new JspException(L.l("unknown formatNumber type `{0}'", this._type));
        }
        format.setParseIntegerOnly(this._integerOnly);
        return format;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jstl.rt.FmtParseNumberTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

