/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.jstl.rt.CoreUrlTag;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.TagSupport;

public class UrlTag
extends TagSupport
implements NameValueTag {
    private static final L10N L = new L10N(UrlTag._resin_compat_class_0());
    private Expr _valueExpr;
    private Expr _contextExpr;
    private String _var;
    private String _scope;
    private CharBuffer _url;
    private static Class _resin_compat_class_0;

    public void setValue(Expr value) {
        this._valueExpr = value;
    }

    public void setContext(Expr context) {
        this._contextExpr = context;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void addParam(String name, String value) {
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        CoreUrlTag.addParam(this._url, name, value, encoding);
    }

    public int doStartTag() throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            String value = this._valueExpr.evalString(pageContext);
            String context = null;
            if (this._contextExpr != null) {
                context = this._contextExpr.evalString(pageContext);
            }
            this._url = UrlTag.normalizeURL(pageContext, value, context);
            return 1;
        }
        catch (ELException e) {
            throw new JspException((Throwable)e);
        }
    }

    public int doEndTag() throws JspException {
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        String value = UrlTag.encodeURL(pageContext, this._url);
        try {
            if (this._var == null) {
                JspWriter out = pageContext.getOut();
                out.print(value);
            } else {
                CoreSetTag.setValue(pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public static CharBuffer normalizeURL(PageContext pageContext, String url, String context) throws JspException {
        if (url == null) {
            url = "";
        }
        CharBuffer value = new CharBuffer();
        int slash = url.indexOf(47);
        int colon = url.indexOf(58);
        if (colon > 0 && colon < slash) {
            value.append(url);
        } else if (slash == 0) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            if (context != null) {
                value.append(context);
                value.append(url);
            } else {
                value.append(request.getContextPath());
                value.append(url);
            }
        } else if (context != null) {
            value.append(context);
            value.append(url);
        } else {
            value.append(url);
        }
        return value;
    }

    public static String encodeURL(PageContext pageContext, CharBuffer url) {
        int slash;
        String value = url.toString();
        int colon = value.indexOf(58);
        if (colon < (slash = value.indexOf(47)) && slash > 0) {
            return value;
        }
        return ((HttpServletResponse)pageContext.getResponse()).encodeURL(value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jstl.el.ImportTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

