/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jstl.el.SqlQueryTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;

public class SqlTransactionTag
extends TagSupport
implements TryCatchFinally {
    private static final Logger log = Log.open(SqlTransactionTag._resin_compat_class_0());
    private static final L10N L = new L10N(SqlTransactionTag._resin_compat_class_0());
    private Expr _dataSource;
    private Expr _isolation;
    private Connection _conn;
    private int _oldIsolation;
    private static Class _resin_compat_class_0;

    public void setDataSource(Expr dataSource) {
        this._dataSource = dataSource;
    }

    public void setIsolation(Expr isolation) {
        this._isolation = isolation;
    }

    public int doStartTag() throws JspException {
        if (this.pageContext.getAttribute("caucho.jstl.sql.conn") != null) {
            throw new JspTagException(L.l("nexted sql:transaction are forbidden"));
        }
        VariableResolver env = (VariableResolver)this.pageContext;
        try {
            DataSource ds = this._dataSource != null ? SqlQueryTag.getDataSource(this.pageContext, this._dataSource.evalObject(env)) : SqlQueryTag.getDataSource(this.pageContext, null);
            int isolationCode = -1;
            if (this._isolation != null) {
                String isolation = this._isolation.evalString(env);
                if (isolation.equals("read_committed")) {
                    isolationCode = 2;
                } else if (isolation.equals("read_uncommitted")) {
                    isolationCode = 1;
                } else if (isolation.equals("repeatable_read")) {
                    isolationCode = 4;
                } else if (isolation.equals("serializable")) {
                    isolationCode = 8;
                } else {
                    throw new JspTagException(L.l("unknown sql:transaction isolation ~{0}'", isolation));
                }
            }
            this._conn = ds.getConnection();
            this._oldIsolation = this._conn.getTransactionIsolation();
            this._conn.setAutoCommit(false);
            if (this._isolation != null && isolationCode != this._oldIsolation) {
                this._conn.setTransactionIsolation(isolationCode);
            }
            this.pageContext.setAttribute("caucho.jstl.sql.conn", (Object)this._conn);
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        if (this._conn != null) {
            this._conn.rollback();
        }
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinally() {
        block13: {
            try {
                this.pageContext.removeAttribute("caucho.jstl.sql.conn");
                if (this._conn == null) break block13;
                Connection conn = this._conn;
                this._conn = null;
                try {
                    conn.commit();
                }
                finally {
                    try {
                        conn.setTransactionIsolation(this._oldIsolation);
                    }
                    catch (SQLException e) {}
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jstl.el.SqlTransactionTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

