/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.jsp.JspLineParseException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.cfg.TldPreload;
import com.caucho.jsp.cfg.TldTaglib;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldManager {
    static final L10N L = new L10N(TldManager._resin_compat_class_0());
    private static final Logger log = Log.open(TldManager._resin_compat_class_0());
    private static ArrayList<TldPreload> _cauchoTaglibs;
    private static ArrayList<TldPreload> _globalTaglibs;
    private static ArrayList<Path> _globalPaths;
    private static EnvironmentLocal<TldManager> _localManager;
    private JspResourceManager _resourceManager;
    private Application _application;
    private HashMap<Path, SoftReference<TldTaglib>> _tldMap = new HashMap();
    private JspParseException _loadAllTldException;
    private String _tldDir;
    private FileSetType _tldFileSet;
    private volatile boolean _isInit;
    private Config _config = new Config();
    private ArrayList<TldPreload> _preloadTaglibs;
    private static Class _resin_compat_class_0;

    private TldManager(JspResourceManager resourceManager, Application app) throws JspParseException, IOException {
        JspPropertyGroup jsp;
        this._resourceManager = resourceManager;
        this._application = app;
        if (app != null && (jsp = app.getJsp()) != null) {
            this._tldFileSet = jsp.getTldFileSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TldManager create(JspResourceManager resourceManager, Application app) throws JspParseException, IOException {
        TldManager manager = null;
        Object object = _localManager;
        synchronized (object) {
            manager = _localManager.getLevel();
            if (manager != null) {
                return manager;
            }
            manager = new TldManager(resourceManager, app);
            _localManager.set(manager);
        }
        object = manager;
        synchronized (object) {
            manager.init();
        }
        return manager;
    }

    void setApplication(Application application) {
        this._application = application;
    }

    public String getSchema() {
        return "com/caucho/jsp/cfg/jsp-tld.rnc";
    }

    public void setTldDir(String tldDir) {
        this._tldDir = tldDir;
    }

    public void setTldFileSet(FileSetType tldFileSet) {
        this._tldFileSet = tldFileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() throws JspParseException, IOException {
        int i;
        ArrayList<Path> paths;
        ClassLoader oldLoader;
        Thread thread;
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        int maxDepth = 64;
        if (_cauchoTaglibs == null) {
            ArrayList<TldPreload> cauchoTaglibs = new ArrayList<TldPreload>();
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            try {
                MergePath cauchoClassPath = new MergePath();
                cauchoClassPath.addClassPath();
                this.loadClassPathTlds(cauchoTaglibs, cauchoClassPath.getMergePaths(), "com/caucho");
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
            _cauchoTaglibs = cauchoTaglibs;
        }
        if (_globalTaglibs == null) {
            ArrayList<TldPreload> globalTaglibs = new ArrayList<TldPreload>();
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getClass().getClassLoader());
            try {
                MergePath globalClassPath = new MergePath();
                globalClassPath.addClassPath();
                paths = globalClassPath.getMergePaths();
                _globalPaths = paths;
                this.loadClassPathTlds(globalTaglibs, paths, "");
                for (i = globalTaglibs.size() - 1; i >= 0; --i) {
                    String tldPathName;
                    TldPreload tld = globalTaglibs.get(i);
                    if (tld.getPath() == null || tld.getPath().getPath() == null || !(tldPathName = tld.getPath().getPath()).startsWith("/com/caucho")) continue;
                    globalTaglibs.remove(i);
                }
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
            _globalTaglibs = globalTaglibs;
        }
        String dir = this._tldDir == null ? "WEB-INF" : (this._tldDir.startsWith("/") ? this._tldDir.substring(1) : (this._tldDir.startsWith("WEB-INF") ? this._tldDir : new CharBuffer().append("WEB-INF/").append(this._tldDir).toString()));
        FileSetType fileSet = this._tldFileSet;
        if (fileSet == null) {
            fileSet = new FileSetType();
            fileSet.setDir(this._resourceManager.resolvePath(dir));
            try {
                fileSet.init();
            }
            catch (Exception e) {
                log.config(e.toString());
            }
        }
        ArrayList<TldPreload> taglibs = new ArrayList<TldPreload>();
        taglibs.addAll(_globalTaglibs);
        MergePath classPath = new MergePath();
        classPath.addClassPath();
        paths = classPath.getMergePaths();
        for (i = 0; i < paths.size(); ++i) {
            Path subPath = paths.get(i);
            if (_globalPaths.contains(subPath)) continue;
            if (subPath instanceof JarPath) {
                this.loadJarTlds(taglibs, (JarPath)subPath, "META-INF");
                continue;
            }
            this.loadAllTlds(taglibs, subPath.lookup("META-INF"), 64, "META-INF");
        }
        if (fileSet != null) {
            this.loadAllTlds(taglibs, fileSet);
        }
        taglibs.addAll(_cauchoTaglibs);
        this._preloadTaglibs = taglibs;
    }

    private void loadClassPathTlds(ArrayList<TldPreload> taglibs, ArrayList<Path> paths, String prefix) throws JspParseException, IOException {
        for (int i = 0; i < paths.size(); ++i) {
            Path subPath = paths.get(i);
            if (subPath instanceof JarPath) {
                this.loadJarTlds(taglibs, (JarPath)subPath, prefix);
                continue;
            }
            if (prefix != null && !prefix.equals("")) {
                this.loadAllTlds(taglibs, subPath.lookup(prefix), 64, prefix);
                continue;
            }
            this.loadAllTlds(taglibs, subPath.lookup("META-INF"), 64, "META-INF");
        }
    }

    private void loadAllTlds(ArrayList<TldPreload> taglibs, FileSetType fileSet) throws JspParseException, IOException {
        for (Path path : fileSet.getPaths()) {
            if (path.getPath().startsWith(".") || !path.getPath().endsWith(".tld") || !path.isFile() || !path.canRead()) continue;
            try {
                TldPreload taglib = this.parseTldPreload(path);
                taglibs.add(taglib);
                if (taglib.getURI() != null || taglib.getConfigException() == null || this._loadAllTldException != null) continue;
                this._loadAllTldException = new JspLineParseException(taglib.getConfigException());
            }
            catch (Throwable e) {
                log.warning(e.getMessage());
            }
        }
    }

    private void loadAllTlds(ArrayList<TldPreload> taglibs, Path path, int depth, String userPath) throws JspParseException, IOException {
        if (depth < 0) {
            throw new JspParseException(L.l("max depth exceeded while reading .tld files.  Probable loop in filesystem detected at `{0}'.", path));
        }
        path.setUserPath(userPath);
        if (!path.getPath().startsWith(".")) {
            if (path.getPath().endsWith(".tld") && path.isFile() && path.canRead()) {
                try {
                    TldPreload taglib = this.parseTldPreload(path);
                    taglibs.add(taglib);
                    if (taglib.getURI() == null && taglib.getConfigException() != null && this._loadAllTldException == null) {
                        this._loadAllTldException = new JspLineParseException(taglib.getConfigException());
                    }
                }
                catch (Throwable e) {
                    log.warning(e.getMessage());
                }
            } else if (path.isDirectory()) {
                String[] fileNames = path.list();
                for (int i = 0; fileNames != null && i < fileNames.length; ++i) {
                    String name = fileNames[i];
                    ArrayList<Path> resources = path.getResources(name);
                    for (int j = 0; resources != null && j < resources.size(); ++j) {
                        Path subpath = resources.get(j);
                        this.loadAllTlds(taglibs, subpath, depth - 1, new CharBuffer().append(userPath).append("/").append(name).toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarTlds(ArrayList<TldPreload> taglibs, JarPath jar, String prefix) throws JspParseException, IOException {
        if (!jar.getContainer().canRead()) {
            return;
        }
        String nativePath = jar.getContainer().getNativePath();
        ZipFile zipFile = nativePath.endsWith(".jar") ? new JarFile(nativePath) : new ZipFile(nativePath);
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefix) || !name.endsWith(".tld")) continue;
                Path path = jar.lookup(name);
                try {
                    TldPreload taglib = this.parseTldPreload(path);
                    taglibs.add(taglib);
                    if (taglib.getURI() != null || taglib.getConfigException() == null || this._loadAllTldException != null) continue;
                    this._loadAllTldException = new JspLineParseException(taglib.getConfigException());
                }
                catch (Throwable e) {
                    log.warning(e.getMessage());
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    TldTaglib parseTld(String uri, String mapLocation, String location) throws JspParseException, IOException {
        for (int i = 0; i < this._preloadTaglibs.size(); ++i) {
            TldPreload preload = this._preloadTaglibs.get(i);
            if (!uri.equals(preload.getURI()) || mapLocation != null && !mapLocation.equals(preload.getLocation()) && !mapLocation.equals(uri)) continue;
            return this.parseTld(preload.getPath());
        }
        return this.parseTld(location);
    }

    TldTaglib parseTld(String location) throws JspParseException, IOException {
        TldTaglib tld = this.findTld(location);
        return tld;
    }

    private TldTaglib findTld(String location) throws JspParseException, IOException {
        Path path;
        Object is = null;
        if (location.startsWith("file:")) {
            path = this._resourceManager.resolvePath(location);
        } else {
            if (location.indexOf(58) >= 0 && !location.startsWith("file:") && location.indexOf(58) < location.indexOf(47)) {
                if (this._loadAllTldException != null) {
                    throw this._loadAllTldException;
                }
                return null;
            }
            path = !location.startsWith("/") ? this._resourceManager.resolvePath(new CharBuffer().append("WEB-INF/").append(location).toString()) : this._resourceManager.resolvePath(new CharBuffer().append(".").append(location).toString());
        }
        path.setUserPath(location);
        JarPath jar = null;
        if (location.endsWith(".jar")) {
            path = this.findJar(location);
            if (path != null && path.exists()) {
                jar = JarPath.create(path);
                if (jar.lookup("META-INF/taglib.tld").exists()) {
                    return this.parseTld(jar.lookup("META-INF/taglib.tld"));
                }
                if (jar.lookup("meta-inf/taglib.tld").exists()) {
                    return this.parseTld(jar.lookup("meta-inf/taglib.tld"));
                }
                throw new JspParseException(L.l("can't find META-INF/taglib.tld in `{0}'", location));
            }
            throw new JspParseException(L.l("Can't find taglib `{0}'.  A taglib uri ending in *.jar must point to an actual jar or match a taglib-uri in a taglib map.", location));
        }
        if (path.exists() && path.canRead() && path.isFile()) {
            return this.parseTld(path);
        }
        if (this._loadAllTldException != null) {
            throw this._loadAllTldException;
        }
        throw new JspParseException(L.l("Can't find taglib-location `{0}'.  The taglib-location must match a tag library either:\n1) by pointing to a .tld directly, relative to the application's root directory\n2) specified in the web.xml\n3) defined in a jar's .tld in META-INF\n4) defined in a .tld in WEB-INF\n5) predefined by Resin", location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldTaglib parseTld(Path path) throws JspParseException, IOException {
        TldTaglib taglib;
        SoftReference<TldTaglib> taglibRef = this._tldMap.get(path);
        if (taglibRef != null && (taglib = taglibRef.get()) != null && !taglib.isModified()) {
            return taglib;
        }
        ReadStream is = path.openRead();
        try {
            taglib = this.parseTld(is);
            if (path instanceof JarPath) {
                taglib.setJarPath(path.lookup("/"));
            }
            this._tldMap.put(path, new SoftReference<TldTaglib>(taglib));
            TldTaglib tldTaglib = taglib;
            return tldTaglib;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldTaglib parseTld(InputStream is) throws JspParseException, IOException {
        TldTaglib taglib = new TldTaglib();
        if (is instanceof ReadStream) {
            Path path = ((ReadStream)is).getPath();
            path.setUserPath(path.getURL());
        }
        String schema = null;
        if (this._application.getJsp() == null || this._application.getJsp().isValidateTaglibSchema()) {
            schema = this.getSchema();
        }
        try {
            new Config().configure((Object)taglib, is, schema);
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        catch (Exception e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        finally {
            is.close();
        }
        return taglib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldPreload parseTldPreload(Path path) throws JspParseException, IOException {
        ReadStream is = path.openRead();
        try {
            TldPreload taglib = this.parseTldPreload(is);
            taglib.setPath(path);
            String appDir = this._application.getAppDir().getPath();
            String tagPath = path.getPath();
            if (tagPath.startsWith(appDir)) {
                taglib.setLocation(tagPath.substring(appDir.length()));
            }
            TldPreload tldPreload = taglib;
            return tldPreload;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldPreload parseTldPreload(InputStream is) throws JspParseException, IOException {
        if (is instanceof ReadStream) {
            Path path = ((ReadStream)is).getPath();
            path.setUserPath(path.getURL());
        }
        String schema = null;
        if (this._application.getJsp() == null || this._application.getJsp().isValidateTaglibSchema()) {
            schema = this.getSchema();
        }
        TldPreload taglib = new TldPreload();
        try {
            this._config.configure((Object)taglib, is, schema);
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        catch (Exception e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        finally {
            is.close();
        }
        try {
            if (taglib.getConfigException() == null) {
                taglib.init(this._application);
            }
        }
        catch (Exception e) {
            throw new JspParseException(e);
        }
        return taglib;
    }

    private Path findJar(String location) {
        String sub;
        Path path = location.startsWith("file:") ? Vfs.lookup(location) : (location.startsWith("/") ? this._resourceManager.resolvePath(new CharBuffer().append(".").append(location).toString()) : this._resourceManager.resolvePath(location));
        if (path.exists()) {
            return path;
        }
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        String classPath = loader.getClassPath();
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while ((tail = classPath.indexOf(sep, head)) >= 0) {
            sub = classPath.substring(head, tail);
            path = Vfs.lookup(sub);
            if (sub.endsWith(location) && path.exists()) {
                return path;
            }
            head = tail + 1;
        }
        if (classPath.length() <= head) {
            return null;
        }
        sub = classPath.substring(head);
        path = Vfs.lookup(sub);
        if (sub.endsWith(location) && path.exists()) {
            return path;
        }
        return null;
    }

    static {
        _localManager = new EnvironmentLocal();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jsp.TldManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

