/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.types.FileSetType;
import com.caucho.jsp.AnalyzedTag;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.TagAnalyzer;
import com.caucho.jsp.Taglib;
import com.caucho.jsp.TldManager;
import com.caucho.jsp.cfg.TldTaglib;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class TaglibManager {
    static final L10N L = new L10N(TaglibManager._resin_compat_class_0());
    private static final Logger log = Log.open(TaglibManager._resin_compat_class_0());
    private static ArrayList<TldTaglib> _cauchoTaglibs;
    private JspResourceManager _resourceManager;
    private Application _application;
    private TldManager _tldManager;
    private String _tldDir;
    private FileSetType _tldFileSet;
    private HashMap<String, String> _uriLocationMap = new HashMap();
    private HashMap<String, TldTaglib> _tldMap = new HashMap();
    private HashMap<String, Taglib> _taglibMap = new HashMap();
    private HashMap<String, Taglib> _taglibDirMap = new HashMap();
    private JspParseException _loadAllTldException;
    private TagAnalyzer _tagAnalyzer = new TagAnalyzer();
    private volatile boolean _isInit;
    private static Class _resin_compat_class_0;

    public TaglibManager(JspResourceManager resourceManager, Application application) throws JspParseException, IOException {
        this._resourceManager = resourceManager;
        this._application = application;
        this._tldManager = TldManager.create(resourceManager, application);
    }

    void setApplication(Application application) {
        this._application = application;
    }

    public void setTldDir(String tldDir) {
        this._tldDir = tldDir;
    }

    public void setTldFileSet(FileSetType fileSet) {
        this._tldManager.setTldFileSet(fileSet);
    }

    public void addLocationMap(String uri, String location) {
        this._uriLocationMap.put(uri, location);
    }

    public synchronized void init() throws JspParseException, IOException {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
    }

    AnalyzedTag analyzeTag(Class cl) {
        return this._tagAnalyzer.analyze(cl);
    }

    public synchronized Taglib getTaglib(String prefix, String uri, String location) throws JspParseException {
        if ("http://java.sun.com/JSP/Page".equals(uri)) {
            return null;
        }
        if (prefix != null && prefix.startsWith("jsp")) {
            throw new JspParseException(L.l("tag prefix '{0}' may not start with 'jsp'.", prefix));
        }
        try {
            this.init();
        }
        catch (IOException e) {
            throw new JspParseException(e);
        }
        Taglib taglib = this._taglibMap.get(uri);
        if (taglib != null) {
            return taglib;
        }
        String mapLocation = this._uriLocationMap.get(uri);
        if (mapLocation != null) {
            location = mapLocation;
        }
        if ((taglib = this.readTaglib(prefix, uri, location)) != null) {
            this._taglibMap.put(uri, taglib);
        }
        return taglib;
    }

    public synchronized Taglib getTaglibDir(String prefix, String dir) throws JspParseException {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new JspParseException(e);
        }
        Taglib taglib = this._taglibDirMap.get(dir);
        if (taglib != null) {
            return taglib;
        }
        TldTaglib tldTaglib = new TldTaglib();
        taglib = new Taglib(prefix, new CharBuffer().append("urn:jsptagdir:").append(dir).toString(), tldTaglib);
        if (taglib != null) {
            this._taglibDirMap.put(dir, taglib);
        }
        return taglib;
    }

    private Taglib readTaglib(String prefix, String uri, String location) throws JspParseException {
        try {
            TldTaglib tldTaglib = this._tldMap.get(uri);
            if (tldTaglib == null) {
                String mapLocation = this._uriLocationMap.get(uri);
                if ((location == null || location.equals("")) && (mapLocation == null || mapLocation.equals(""))) {
                    return null;
                }
                tldTaglib = this._tldManager.parseTld(uri, mapLocation, location);
                this._tldMap.put(uri, tldTaglib);
            }
            if (tldTaglib != null) {
                if (tldTaglib.getConfigException() != null) {
                    throw JspParseException.create(tldTaglib.getConfigException());
                }
                return new Taglib(prefix, uri, tldTaglib);
            }
            return null;
        }
        catch (JspParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspParseException(e);
        }
    }

    private Path findJar(String location) {
        String sub;
        Path path = location.startsWith("file:") ? Vfs.lookup(location) : (location.startsWith("/") ? this._resourceManager.resolvePath(new CharBuffer().append(".").append(location).toString()) : this._resourceManager.resolvePath(location));
        if (path.exists()) {
            return path;
        }
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        String classPath = loader.getClassPath();
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while ((tail = classPath.indexOf(sep, head)) >= 0) {
            sub = classPath.substring(head, tail);
            path = Vfs.lookup(sub);
            if (sub.endsWith(location) && path.exists()) {
                return path;
            }
            head = tail + 1;
        }
        if (classPath.length() <= head) {
            return null;
        }
        sub = classPath.substring(head);
        path = Vfs.lookup(sub);
        if (sub.endsWith(location) && path.exists()) {
            return path;
        }
        return null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jsp.TaglibManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

