/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.java.TagTaglib;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class TagFileManager {
    static final L10N L = new L10N(TagFileManager._resin_compat_class_0());
    private static final Logger log = Log.open(TagFileManager._resin_compat_class_0());
    private JspCompiler _jspCompiler;
    private JspResourceManager _resourceManager;
    private static Class _resin_compat_class_0;

    public TagFileManager(JspCompiler compiler) throws JspParseException, IOException {
        this._jspCompiler = compiler;
        this._resourceManager = this._jspCompiler.getResourceManager();
    }

    public TagInfo getTag(String prefix, String shortName, String location) throws JspParseException {
        if (location == null) {
            return null;
        }
        try {
            TagTaglib taglib;
            String uri;
            TagInfo tag;
            String originalLocation = location;
            if (location.startsWith("urn:jsptagdir:")) {
                location = location.substring("urn:jsptagdir:".length());
            }
            if (!location.endsWith("/")) {
                location = new CharBuffer().append(location).append("/").toString();
            }
            if ((tag = this.getTag(uri = new CharBuffer().append(location).append(shortName).append(".tag").toString(), taglib = new TagTaglib(prefix, originalLocation))) != null) {
                return tag;
            }
            uri = new CharBuffer().append(location).append(shortName).append(".tagx").toString();
            return this.getTag(uri, taglib);
        }
        catch (Exception e) {
            throw JspParseException.create(e);
        }
    }

    public TagInfo getTag(String prefix, String location) throws JspParseException {
        TagTaglib taglib = new TagTaglib(prefix, location);
        return this.getTag(location, taglib);
    }

    public TagInfo getTag(String location, TagLibraryInfo taglib) throws JspParseException {
        if (this._resourceManager == null) {
            return null;
        }
        Path path = this._resourceManager.resolvePath(location);
        return this.getTag(path, location, taglib);
    }

    public TagInfo getTag(Path path, String prefix, String location) throws JspParseException {
        TagTaglib taglib = new TagTaglib(prefix, location);
        return this.getTag(path, location, taglib);
    }

    public TagInfo getTag(Path path, String location, TagLibraryInfo taglib) throws JspParseException {
        if (!path.canRead()) {
            return null;
        }
        try {
            if (location.endsWith(".tag")) {
                JspCompilerInstance tagCompiler = this._jspCompiler.getCompilerInstance(path, location);
                tagCompiler.setXML(false);
                return tagCompiler.compileTag(taglib);
            }
            if (location.endsWith(".tagx")) {
                JspCompilerInstance tagCompiler = this._jspCompiler.getCompilerInstance(path, location);
                tagCompiler.setXML(true);
                return tagCompiler.compileTag(taglib);
            }
            throw new JspParseException(L.l("tag file `{0}' must end with .tag or .tagx", location));
        }
        catch (Exception e) {
            throw JspParseException.create(e);
        }
    }

    public Class loadClass(String className) throws Exception {
        Path classDir = this._jspCompiler.getClassDir();
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        DynamicClassLoader jspLoader = SimpleLoader.create(parentLoader, classDir, null);
        return Class.forName(className, false, jspLoader);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jsp.TagFileManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

