/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.TimedCache;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManager {
    private static final L10N L = new L10N(BundleManager._resin_compat_class_0());
    private static final Logger log = Log.open(BundleManager._resin_compat_class_0());
    static LocalizationContext NULL_BUNDLE = new LocalizationContext();
    private static EnvironmentLocal<BundleManager> _envBundle = new EnvironmentLocal();
    private TimedCache<String, LocalizationContext> _bundleCache;
    private static Class _resin_compat_class_0;

    private BundleManager() {
        long updateInterval = Environment.getDependencyCheckInterval();
        this._bundleCache = new TimedCache(256, updateInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleManager create() {
        BundleManager manager;
        EnvironmentLocal<BundleManager> environmentLocal = _envBundle;
        synchronized (environmentLocal) {
            manager = _envBundle.get();
            if (manager == null) {
                manager = new BundleManager();
                _envBundle.set(manager);
            }
        }
        return manager;
    }

    public LocalizationContext getBundle(String name, String cacheKey, Enumeration<Locale> locales) {
        LocalizationContext cachedValue = this._bundleCache.get(cacheKey);
        if (cachedValue != null) {
            return cachedValue == NULL_BUNDLE ? null : cachedValue;
        }
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            LocalizationContext bundle = this.getBundle(name, locale);
            if (bundle == null) continue;
            this._bundleCache.put(cacheKey, bundle);
            return bundle;
        }
        this._bundleCache.put(cacheKey, NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name, Locale locale) {
        String cacheName = new CharBuffer().append(name).append('_').append(locale.getLanguage()).append('_').append(locale.getCountry()).append('_').append(locale.getVariant()).toString();
        LocalizationContext bundle = this._bundleCache.get(cacheName);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        String fullName = cacheName;
        ResourceBundle resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleCache.put(cacheName, bundle);
            return bundle;
        }
        fullName = new CharBuffer().append(name).append('_').append(locale.getLanguage()).append('_').append(locale.getCountry()).toString();
        resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleCache.put(cacheName, bundle);
            return bundle;
        }
        fullName = new CharBuffer().append(name).append('_').append(locale.getLanguage()).toString();
        resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleCache.put(cacheName, bundle);
            return bundle;
        }
        this._bundleCache.put(cacheName, NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name) {
        LocalizationContext bundle = this._bundleCache.get(name);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        ResourceBundle resourceBundle = this.getBaseBundle(name);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle);
            this._bundleCache.put(name, bundle);
            return bundle;
        }
        this._bundleCache.put(name, NULL_BUNDLE);
        return null;
    }

    private ResourceBundle getBaseBundle(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ResourceBundle rb;
            Class<?> cl = Class.forName(name, false, loader);
            if (cl != null && (rb = (ResourceBundle)cl.newInstance()) != null) {
                return rb;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            InputStream is = loader.getResourceAsStream(new CharBuffer().append(name.replace('.', '/')).append(".properties").toString());
            if (is instanceof ReadStream) {
                Path path = ((ReadStream)is).getPath();
                Environment.addDependency(new Depend(path));
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            is.close();
            return bundle;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jsp.BundleManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

