/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.jmx.MBeanContext;
import com.caucho.jmx.MBeanServerDelegateImpl;
import com.caucho.jmx.MBeanWrapper;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerDelegate;

public class EnvironmentMBeanServer
extends AbstractMBeanServer {
    private static final L10N L = new L10N(EnvironmentMBeanServer._resin_compat_class_1());
    private static final Logger log = Log.open(EnvironmentMBeanServer._resin_compat_class_1());
    private EnvironmentLocal<MBeanContext> _localContext = new EnvironmentLocal();
    private MBeanServerDelegate _globalDelegate;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public EnvironmentMBeanServer(String domain, MBeanServerDelegate delegate) {
        super(domain);
        if (Jmx.getMBeanServer() == null) {
            Jmx.setMBeanServer(this);
        }
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        MBeanContext context = new MBeanContext(this, systemLoader, delegate);
        this._localContext.set(context, systemLoader);
        try {
            IntrospectionMBean mbean = new IntrospectionMBean(delegate, EnvironmentMBeanServer._resin_compat_class_0());
            MBeanWrapper mbeanWrapper = new MBeanWrapper(context, SERVER_DELEGATE_NAME, delegate, mbean);
            context.registerMBean(mbeanWrapper, SERVER_DELEGATE_NAME);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanContext getContext(ClassLoader loader) {
        EnvironmentLocal<MBeanContext> environmentLocal = this._localContext;
        synchronized (environmentLocal) {
            MBeanContext context = this._localContext.getLevel(loader);
            if (context == null) {
                MBeanServerDelegateImpl delegate = new MBeanServerDelegateImpl("Resin-JMX");
                context = new MBeanContext(this, loader, delegate);
                MBeanContext parent = null;
                if (loader != null) {
                    parent = this.getContext(loader.getParent());
                }
                if (parent != null) {
                    context.setProperties(parent.copyProperties());
                }
                this._localContext.set(context, loader);
                try {
                    IntrospectionMBean mbean = new IntrospectionMBean(delegate, EnvironmentMBeanServer._resin_compat_class_0());
                    MBeanWrapper mbeanWrapper = new MBeanWrapper(context, SERVER_DELEGATE_NAME, delegate, mbean);
                    context.registerMBean(mbeanWrapper, SERVER_DELEGATE_NAME);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanContext getExistingContext(ClassLoader loader) {
        if (loader == null) {
            return this._localContext.get(ClassLoader.getSystemClassLoader());
        }
        EnvironmentLocal<MBeanContext> environmentLocal = this._localContext;
        synchronized (environmentLocal) {
            return this._localContext.getLevel(loader);
        }
    }

    protected void removeContext(MBeanContext context, ClassLoader loader) {
        if (this._localContext.get(loader) == context) {
            this._localContext.remove(loader);
        }
    }

    public String toString() {
        return "EnvironmentMBeanServer[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.management.MBeanServerDelegateMBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.jmx.EnvironmentMBeanServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

