/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.loading.ClassLoaderRepository;

public class ClassLoaderRepositoryImpl
implements ClassLoaderRepository {
    private static final L10N L = new L10N(ClassLoaderRepositoryImpl._resin_compat_class_0());
    private static final Logger log = Log.open(ClassLoaderRepositoryImpl._resin_compat_class_0());
    private ArrayList<ClassLoader> _loaders = new ArrayList();
    private static Class _resin_compat_class_0;

    void addClassLoader(ClassLoader loader) {
        this._loaders.add(loader);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        for (int i = 0; i < this._loaders.size(); ++i) {
            ClassLoader loader = this._loaders.get(i);
            try {
                Class<?> cl = loader.loadClass(className);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(L.l("can't load class {0}", className));
    }

    public Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
        ClassLoader loader;
        for (int i = 0; i < this._loaders.size() && (loader = this._loaders.get(i)) != stop; ++i) {
            try {
                Class<?> cl = loader.loadClass(className);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(L.l("can't load class {0}", className));
    }

    public Class loadClassWithout(ClassLoader exclude, String className) throws ClassNotFoundException {
        for (int i = 0; i < this._loaders.size(); ++i) {
            ClassLoader loader = this._loaders.get(i);
            if (loader == exclude) continue;
            try {
                Class<?> cl = loader.loadClass(className);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(L.l("can't load class {0}", className));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jmx.ClassLoaderRepositoryImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

