/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.session;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class MessageProducerImpl
implements MessageProducer {
    static final L10N L = new L10N(MessageProducerImpl._resin_compat_class_0());
    private int _deliveryMode = 1;
    private boolean _disableMessageId = true;
    private boolean _disableMessageTimestamp = true;
    private int _priority = 4;
    private long _timeToLive = 2592000000L;
    protected SessionImpl _session;
    protected AbstractDestination _destination;
    private static Class _resin_compat_class_0;

    MessageProducerImpl(SessionImpl session, Destination destination) {
        this._session = session;
        this._destination = (AbstractDestination)destination;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this._deliveryMode = deliveryMode;
    }

    public boolean getDisableMessageID() {
        return this._disableMessageId;
    }

    public void setDisableMessageID(boolean disable) {
        this._disableMessageId = disable;
    }

    public boolean getDisableMessageTimestamp() {
        return this._disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disable) {
        this._disableMessageTimestamp = disable;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public long getTimeToLive() {
        return this._timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this._timeToLive = timeToLive;
    }

    public void send(Message message) throws JMSException {
        this._session.send(this._destination, (MessageImpl)message, this._deliveryMode, this._priority, this.calculateExpiration(this._timeToLive));
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this._session.send(this._destination, (MessageImpl)message, deliveryMode, priority, this.calculateExpiration(timeToLive));
    }

    public void send(Destination destination, Message message) throws JMSException {
        this._session.send((AbstractDestination)destination, (MessageImpl)message, this._deliveryMode, this._priority, this.calculateExpiration(this._timeToLive));
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this._session.send((AbstractDestination)destination, (MessageImpl)message, deliveryMode, priority, this.calculateExpiration(timeToLive));
    }

    protected long calculateExpiration(long timeToLive) {
        if (timeToLive <= 0L) {
            return timeToLive;
        }
        return timeToLive + Alarm.getCurrentTime();
    }

    public void close() throws JMSException {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.jms.MessageProducer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

