/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.BetweenSelector;
import com.caucho.jms.selector.BooleanBinarySelector;
import com.caucho.jms.selector.BooleanLiteralSelector;
import com.caucho.jms.selector.IdentifierSelector;
import com.caucho.jms.selector.InSelector;
import com.caucho.jms.selector.LikeSelector;
import com.caucho.jms.selector.LiteralSelector;
import com.caucho.jms.selector.NumericBinarySelector;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.UnarySelector;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class SelectorParser {
    static final Logger log = Log.open(SelectorParser._resin_compat_class_0());
    static final L10N L = new L10N(SelectorParser._resin_compat_class_0());
    static final int TRUE = 1;
    static final int FALSE = 2;
    static final int NULL = 3;
    static final int INTEGER = 4;
    static final int DOUBLE = 5;
    static final int LONG = 6;
    static final int STRING = 7;
    static final int IDENTIFIER = 8;
    static final int EQ = 9;
    static final int NE = 10;
    static final int LT = 11;
    static final int LE = 12;
    static final int GT = 13;
    static final int GE = 14;
    static final int NOT = 15;
    static final int AND = 16;
    static final int OR = 17;
    static final int BETWEEN = 18;
    static final int LIKE = 19;
    static final int IN = 20;
    static final int IS = 21;
    private static IntMap _reserved = new IntMap();
    private String _query;
    private int _parseIndex;
    private int _token = -1;
    private String _lexeme;
    private CharBuffer _cb = new CharBuffer();
    private static Class _resin_compat_class_0;

    public Selector parse(String query) throws JMSException {
        this._query = query;
        this._parseIndex = 0;
        if (this.peekToken() == -1) {
            return null;
        }
        Selector selector = this.parseExpr();
        if (!selector.isUnknown() && !selector.isBoolean()) {
            throw new InvalidSelectorException(L.l("selector '{0}' must be a boolean", selector));
        }
        return selector;
    }

    private Selector parseExpr() throws JMSException {
        return this.parseOr();
    }

    private Selector parseOr() throws JMSException {
        Selector left = this.parseAnd();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 17: {
                    this.scanToken();
                    left = new BooleanBinarySelector(token, left, this.parseAnd());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseAnd() throws JMSException {
        Selector left = this.parseCmp();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 16: {
                    this.scanToken();
                    left = new BooleanBinarySelector(token, left, this.parseCmp());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseCmp() throws JMSException {
        int token = this.peekToken();
        boolean isNot = false;
        if (token == 15) {
            this.scanToken();
            isNot = true;
            token = this.peekToken();
        }
        Selector left = this.parseAdd();
        token = this.peekToken();
        if (token == 15) {
            isNot = !isNot;
            this.scanToken();
            token = this.peekToken();
        }
        if (token >= 9 && token <= 14) {
            this.scanToken();
            left = new BooleanBinarySelector(token, left, this.parseAdd());
        } else if (token == 18) {
            this.scanToken();
            Selector low = this.parseAdd();
            token = this.scanToken();
            if (token != 16) {
                throw this.error("BETWEEN needs AND");
            }
            Selector high = this.parseAdd();
            left = new BetweenSelector(left, low, high);
        } else if (token == 19) {
            this.scanToken();
            token = this.scanToken();
            if (token != 7) {
                throw this.error("LIKE needs string pattern");
            }
            left = new LikeSelector(left, this._lexeme);
        } else if (token == 20) {
            this.scanToken();
            InSelector inSelector = new InSelector(left);
            if (this.scanToken() != 40) {
                throw this.error("IN needs `('");
            }
            while ((token = this.scanToken()) == 7) {
                inSelector.addValue(this._lexeme);
                if (this.peekToken() != 44) continue;
                this.scanToken();
            }
            if (token != 41) {
                throw this.error("IN needs `)'");
            }
            this.scanToken();
            left = inSelector;
        } else if (token == 21) {
            this.scanToken();
            if (this.peekToken() == 15) {
                isNot = !isNot;
                this.scanToken();
            }
            if ((token = this.scanToken()) != 3) {
                throw this.error("IS needs NULL");
            }
            left = new UnarySelector(3, left);
        }
        if (isNot) {
            return new UnarySelector(15, left);
        }
        return left;
    }

    private Selector parseAdd() throws JMSException {
        Selector left = this.parseMul();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 43: 
                case 45: {
                    this.scanToken();
                    left = new NumericBinarySelector(token, left, this.parseMul());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseMul() throws JMSException {
        Selector left = this.parseUnary();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 42: 
                case 47: {
                    this.scanToken();
                    left = new NumericBinarySelector(token, left, this.parseUnary());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseUnary() throws JMSException {
        int token = this.peekToken();
        switch (token) {
            case 43: 
            case 45: {
                this.scanToken();
                return new UnarySelector(token, this.parseUnary());
            }
        }
        return this.parseTerm();
    }

    private Selector parseTerm() throws JMSException {
        int token = this.scanToken();
        switch (token) {
            case 1: {
                return new BooleanLiteralSelector(true);
            }
            case 2: {
                return new BooleanLiteralSelector(false);
            }
            case 8: {
                return IdentifierSelector.create(this._lexeme);
            }
            case 7: {
                return new LiteralSelector(this._lexeme);
            }
            case 4: {
                return new LiteralSelector(new Long(this._lexeme));
            }
            case 6: {
                return new LiteralSelector(new Long(this._lexeme));
            }
            case 5: {
                return new LiteralSelector(new Double(this._lexeme));
            }
            case 40: {
                Selector value = this.parseExpr();
                if (this.scanToken() != 41) {
                    throw this.error("expected ')'");
                }
                return value;
            }
        }
        throw this.error(new CharBuffer().append("unknown token: ").append(token).toString());
    }

    private int peekToken() throws JMSException {
        if (this._token > 0) {
            return this._token;
        }
        this._token = this.scanToken();
        return this._token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanToken() throws JMSException {
        if (this._token > 0) {
            int value = this._token;
            this._token = -1;
            return value;
        }
        int sign = 1;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        switch (ch) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 47: {
                return ch;
            }
            case 43: {
                ch = this.read();
                if (ch >= 48 && ch <= 57) break;
                this.unread(ch);
                return 43;
            }
            case 45: {
                ch = this.read();
                if (ch >= 48 && ch <= 57) {
                    sign = -1;
                    break;
                }
                this.unread(ch);
                return 45;
            }
            case 61: {
                return 9;
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 12;
                }
                if (ch == 62) {
                    return 10;
                }
                this.unread(ch);
                return 11;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 14;
                }
                this.unread(ch);
                return 13;
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            this._cb.clear();
            while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                this._cb.append((char)ch);
                ch = this.read();
            }
            this.unread(ch);
            this._lexeme = this._cb.toString();
            String lower = this._lexeme.toLowerCase();
            int token = _reserved.get(lower);
            if (token > 0) {
                return token;
            }
            return 8;
        }
        if (ch >= 48 && ch <= 57) {
            this._cb.clear();
            int type = 4;
            if (sign < 0) {
                this._cb.append('-');
            }
            while (ch >= 48 && ch <= 57) {
                this._cb.append((char)ch);
                ch = this.read();
            }
            if (ch == 46) {
                type = 5;
                this._cb.append('.');
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 101 || ch == 69) {
                type = 5;
                this._cb.append('e');
                ch = this.read();
                if (ch == 43 || ch == 45) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
                if (ch < 48 || ch > 57) {
                    throw this.error(L.l("exponent needs digits at {0}", this.charName(ch)));
                }
                while (ch >= 48 && ch <= 57) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 70 || ch == 68 || ch == 102 || ch == 100) {
                type = 5;
            } else if (ch == 76 || ch == 108) {
                type = 6;
            } else {
                this.unread(ch);
            }
            this._lexeme = this._cb.toString();
            return type;
        }
        if (ch != 39) {
            throw this.error(L.l("unexpected char at {0}", new CharBuffer().append("").append((char)ch).toString()));
        }
        int end = ch;
        this._cb.clear();
        ch = this.read();
        while (ch >= 0) {
            block36: {
                if (ch == end) {
                    int ch1 = this.read();
                    if (ch1 == end) {
                        this._cb.append((char)end);
                        break block36;
                    } else {
                        this.unread(ch1);
                        break;
                    }
                }
                this._cb.append((char)ch);
            }
            ch = this.read();
        }
        if (ch < 0) {
            throw this.error(L.l("unexpected end of selector"));
        }
        this._lexeme = this._cb.toString();
        return 7;
    }

    private int read() {
        if (this._parseIndex < this._query.length()) {
            return this._query.charAt(this._parseIndex++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._parseIndex;
        }
    }

    public JMSException error(String msg) {
        msg = new CharBuffer().append(msg).append("\nin \"").append(this._query).append("\"").toString();
        return new InvalidSelectorException(msg);
    }

    private String charName(int ch) {
        if (ch < 0) {
            return L.l("end of query");
        }
        return String.valueOf((char)ch);
    }

    static {
        _reserved.put("true", 1);
        _reserved.put("false", 2);
        _reserved.put("and", 16);
        _reserved.put("or", 17);
        _reserved.put("not", 15);
        _reserved.put("null", 3);
        _reserved.put("is", 21);
        _reserved.put("in", 20);
        _reserved.put("like", 19);
        _reserved.put("between", 18);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.selector.SelectorParser");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

