/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.resource;

import com.caucho.config.ConfigException;
import com.caucho.jms.AbstractDestination;
import com.caucho.jms.ConnectionFactoryImpl;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class MessageSenderResource
implements MessageSender {
    private static final L10N L = new L10N(MessageSenderResource._resin_compat_class_0());
    private static final Logger log = Log.open(MessageSenderResource._resin_compat_class_0());
    private ConnectionFactory _connFactory;
    private Connection _conn;
    private Destination _destination;
    private static Class _resin_compat_class_0;

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connFactory = factory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void init() throws JMSException, ConfigException {
        if (this._destination == null) {
            throw new ConfigException(L.l("'destination' required for message sender."));
        }
        if (this._connFactory == null && this._destination instanceof AbstractDestination) {
            this._connFactory = new ConnectionFactoryImpl();
        }
        if (this._connFactory == null) {
            throw new ConfigException(L.l("'connection-factory' required for message sender"));
        }
        this._conn = this._connFactory.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(HashMap header, Object value) throws MessageServiceException {
        try {
            Session session = this.getSession();
            try {
                Message message;
                if (value == null) {
                    message = session.createMessage();
                } else if (value instanceof String) {
                    message = session.createTextMessage((String)value);
                } else if (value instanceof Serializable) {
                    ObjectMessage objMessage = session.createObjectMessage();
                    objMessage.setObject((Serializable)value);
                    message = objMessage;
                } else {
                    throw new MessageServiceException(L.l("value '{0}' must be serializable", value));
                }
                MessageProducer producer = session.createProducer(this._destination);
                producer.send(message);
                producer.close();
            }
            finally {
                session.close();
            }
        }
        catch (MessageServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageServiceException(e);
        }
    }

    private Session getSession() throws JMSException {
        return this._conn.createSession(false, 1);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.resource.MessageSenderResource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

