/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.memory.MemoryTopicConsumer;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MemoryTopic
extends AbstractDestination
implements Topic {
    static final Logger log = Log.open(MemoryTopic._resin_compat_class_0());
    static final L10N L = new L10N(MemoryTopic._resin_compat_class_0());
    ArrayList<MemoryQueue> _subscribers = new ArrayList();
    private HashMap<String, MemoryQueue> _durableSubscribers = new HashMap();
    private String _topicName;
    private static Class _resin_compat_class_0;

    public String getTopicName() {
        return this._topicName;
    }

    public void setTopicName(String name) {
        this._topicName = name;
    }

    public void send(Message message) throws JMSException {
        for (int i = 0; i < this._subscribers.size(); ++i) {
            MemoryQueue queue = this._subscribers.get(i);
            queue.send(message);
        }
    }

    public MessageConsumer createConsumer(SessionImpl session, String selector, boolean noLocal) throws JMSException {
        return new MemoryTopicConsumer(session, selector, this);
    }

    public TopicSubscriber createDurableSubscriber(SessionImpl session, String selector, boolean noLocal, String name) throws JMSException {
        return new MemoryTopicConsumer(session, selector, this, name);
    }

    public MemoryQueue createDurableSubscriber(String name) throws JMSException {
        MemoryQueue queue = this._durableSubscribers.get(name);
        if (queue == null) {
            queue = this.createSubscriberQueue();
            this._durableSubscribers.put(name, queue);
        }
        return queue;
    }

    MemoryQueue createSubscriberQueue() throws JMSException {
        MemoryQueue queue = new MemoryQueue();
        this._subscribers.add(queue);
        return queue;
    }

    public void removeSubscriber(MemoryQueue queue) {
        this._subscribers.remove(queue);
    }

    public String toString() {
        return new CharBuffer().append("Topic[").append(this._topicName).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.memory.MemoryTopic");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

