/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.jms.jdbc.JdbcTopic;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.sql.DataSource;

public class JdbcTopicConsumer
extends MessageConsumerImpl
implements AlarmListener,
TopicSubscriber {
    static final Logger log = Log.open(JdbcTopicConsumer._resin_compat_class_0());
    static final L10N L = new L10N(JdbcTopicConsumer._resin_compat_class_0());
    private static final long TOPIC_TIMEOUT = 3600000L;
    private JdbcManager _jdbcManager;
    private JdbcTopic _topic;
    private String _subscriber;
    private long _consumerId;
    private long _lastPurgeTime;
    private boolean _isClosed;
    private Alarm _alarm;
    private static Class _resin_compat_class_0;

    public JdbcTopicConsumer(SessionImpl session, String messageSelector, JdbcManager jdbcManager, JdbcTopic topic, boolean noLocal) throws JMSException {
        super(session, messageSelector, topic, noLocal);
        this._jdbcManager = jdbcManager;
        this._topic = topic;
        this.createTopic();
        this._alarm = new Alarm(this, 900000L);
    }

    public JdbcTopicConsumer(SessionImpl session, String messageSelector, JdbcManager jdbcManager, JdbcTopic topic, boolean noLocal, String name) throws JMSException {
        super(session, messageSelector, topic, noLocal);
        this._jdbcManager = jdbcManager;
        this._topic = topic;
        this._subscriber = name;
        this.createTopic(name);
    }

    public Topic getTopic() {
        return this._topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTopic() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            String messageTable = this._jdbcManager.getMessageTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("SELECT MAX(m_id) FROM ").append(messageTable).append(" WHERE queue=?").toString();
                long max = -1L;
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, this._topic.getId());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    max = rs.getLong(1);
                }
                rs.close();
                sql = new CharBuffer().append("INSERT INTO ").append(consumerTable).append(" (queue, expire, read_id, ack_id) VALUES (?,?,?,?)").toString();
                pstmt = conn.prepareStatement(sql, 1);
                pstmt.setInt(1, this._topic.getId());
                pstmt.setLong(2, Alarm.getCurrentTime() + 3600000L);
                pstmt.setLong(3, max);
                pstmt.setLong(4, max);
                pstmt.executeUpdate();
                ResultSet rsKeys = pstmt.getGeneratedKeys();
                if (!rsKeys.next()) {
                    throw new JMSException(L.l("consumer insert didn't create a key"));
                }
                this._consumerId = rsKeys.getLong(1);
                rsKeys.close();
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTopic() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("DELETE FROM ").append(consumerTable).append(" WHERE s_id=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, this._consumerId);
                pstmt.executeUpdate();
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTopic(String name) throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            String consumerSequence = this._jdbcManager.getConsumerSequence();
            String messageTable = this._jdbcManager.getMessageTable();
            String clientId = this._session.getClientID();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("SELECT s_id FROM ").append(consumerTable).append(" WHERE queue=? AND client=? AND name=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, this._topic.getId());
                pstmt.setString(2, clientId);
                pstmt.setString(3, name);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this._consumerId = rs.getLong(1);
                    rs.close();
                    return;
                }
                sql = new CharBuffer().append("SELECT MAX(m_id) FROM ").append(messageTable).append(" WHERE queue=?").toString();
                long max = -1L;
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, this._topic.getId());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    max = rs.getLong(1);
                }
                rs.close();
                pstmt.close();
                if (consumerSequence != null) {
                    sql = this._jdbcManager.getMetaData().selectSequenceSQL(consumerSequence);
                    pstmt = conn.prepareStatement(sql);
                    long id = 0L;
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new IllegalStateException("no sequence value for consumer.");
                    }
                    id = rs.getLong(1);
                    rs.close();
                    pstmt.close();
                    sql = new CharBuffer().append("INSERT INTO ").append(consumerTable).append(" (s_id, queue, client, name, expire, read_id, ack_id) VALUES (?,?,?,?,?,?,?)").toString();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, id);
                    pstmt.setInt(2, this._topic.getId());
                    pstmt.setString(3, clientId);
                    pstmt.setString(4, name);
                    pstmt.setLong(5, 0x3FFFFFFFFFFFFFFFL);
                    pstmt.setLong(6, max);
                    pstmt.setLong(7, max);
                    pstmt.executeUpdate();
                } else {
                    sql = new CharBuffer().append("INSERT INTO ").append(consumerTable).append(" (queue, client, name, expire, read_id, ack_id) VALUES (?,?,?,?,?,?)").toString();
                    pstmt = conn.prepareStatement(sql, 1);
                    pstmt.setInt(1, this._topic.getId());
                    pstmt.setString(2, clientId);
                    pstmt.setString(3, name);
                    pstmt.setLong(4, 0x3FFFFFFFFFFFFFFFL);
                    pstmt.setLong(5, max);
                    pstmt.setLong(6, max);
                    pstmt.executeUpdate();
                    ResultSet rsKeys = pstmt.getGeneratedKeys();
                    if (!rsKeys.next()) {
                        throw new JMSException(L.l("consumer insert didn't create a key"));
                    }
                    this._consumerId = rsKeys.getLong(1);
                    rsKeys.close();
                    pstmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MessageImpl receiveImpl() throws JMSException {
        this.purgeExpiredConsumers();
        this._topic.purgeExpiredMessages();
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            String consumerTable = this._jdbcManager.getConsumerTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("SELECT m_id, msg_type, delivered, body, header FROM ").append(messageTable).append(" m,").append("      ").append(consumerTable).append(" s").append(" WHERE s_id=? AND m.queue=s.queue AND s.read_id<m_id").append("   AND ?<m.expire").append(" ORDER BY m_id").toString();
                PreparedStatement selectStmt = conn.prepareStatement(sql);
                try {
                    selectStmt.setFetchSize(1);
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                long id = -1L;
                selectStmt.setLong(1, this._consumerId);
                selectStmt.setLong(2, Alarm.getCurrentTime());
                MessageImpl msg = null;
                ResultSet rs = selectStmt.executeQuery();
                while (rs.next()) {
                    id = rs.getLong(1);
                    msg = jdbcMessage.readMessage(rs);
                    if (this._selector == null || this._selector.isMatch(msg)) break;
                    msg = null;
                }
                rs.close();
                selectStmt.close();
                if (msg == null) {
                    MessageImpl messageImpl = null;
                    return messageImpl;
                }
                sql = new CharBuffer().append("UPDATE ").append(consumerTable).append(" SET read_id=?").append(" WHERE s_id=?").toString();
                PreparedStatement updateStmt = conn.prepareStatement(sql);
                updateStmt.setLong(1, id);
                updateStmt.setLong(2, this._consumerId);
                updateStmt.executeUpdate();
                updateStmt.close();
                MessageImpl messageImpl = msg;
                return messageImpl;
            }
            finally {
                conn.close();
            }
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("UPDATE ").append(consumerTable).append(" SET ack_id=read_id ").append(" WHERE s_id=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, this._consumerId);
                pstmt.executeUpdate();
                pstmt.close();
                this.deleteOldMessages();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldMessages() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            String consumerTable = this._jdbcManager.getConsumerTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("DELETE FROM ").append(messageTable).append(" WHERE queue=? AND NOT EXISTS(").append("   SELECT * FROM ").append(consumerTable).append("   WHERE queue=? AND ack_id < m_id)").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, this._topic.getId());
                pstmt.setInt(2, this._topic.getId());
                pstmt.executeUpdate();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("UPDATE ").append(consumerTable).append(" SET read_id=ack_id ").append(" WHERE s_id=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, this._consumerId);
                pstmt.executeUpdate();
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeExpiredConsumers() {
        long now = Alarm.getCurrentTime();
        if (now < this._lastPurgeTime + 3600000L) {
            return;
        }
        this._lastPurgeTime = now;
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            String consumerTable = this._jdbcManager.getConsumerTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("DELETE FROM ").append(consumerTable).append(" WHERE is_topic=1 AND expire<?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime());
                pstmt.executeUpdate();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (this._isClosed) {
            return;
        }
        try {
            Connection conn = this._jdbcManager.getDataSource().getConnection();
            try {
                String consumerTable = this._jdbcManager.getConsumerTable();
                String sql = new CharBuffer().append("UPDATE ").append(consumerTable).append(" SET expire=?").append(" WHERE s_id=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime() + 3600000L);
                pstmt.setLong(2, this._consumerId);
                pstmt.executeUpdate();
            }
            finally {
                conn.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._alarm.queue(900000L);
        }
    }

    public void close() throws JMSException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        if (this._alarm != null) {
            this._alarm.dequeue();
        }
        try {
            if (this._subscriber == null) {
                this.deleteTopic();
            } else {
                this._session.unsubscribe(this._subscriber);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        super.close();
    }

    public String toString() {
        return new CharBuffer().append("JdbcTopicConsumer[").append(this._topic).append(",").append(this._consumerId).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.jdbc.JdbcTopicConsumer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

