/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.jms.jdbc.JdbcQueue;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.sql.DataSource;

public class JdbcQueueConsumer
extends MessageConsumerImpl
implements QueueReceiver,
AlarmListener {
    static final Logger log = Log.open(JdbcQueueConsumer._resin_compat_class_0());
    static final L10N L = new L10N(JdbcQueueConsumer._resin_compat_class_0());
    private static final long QUEUE_TIMEOUT = 3600000L;
    private JdbcManager _jdbcManager;
    private JdbcQueue _queue;
    private long _consumerId;
    private boolean _autoAck;
    private boolean _isClosed;
    private Alarm _alarm;
    private long _lastPurgeTime;
    private static Class _resin_compat_class_0;

    public JdbcQueueConsumer(SessionImpl session, String messageSelector, JdbcManager jdbcManager, JdbcQueue queue) throws JMSException {
        block5: {
            block4: {
                super(session, messageSelector, queue, false);
                this._jdbcManager = jdbcManager;
                this._queue = queue;
                if (session.getAcknowledgeMode() == 1) break block4;
                if (session.getAcknowledgeMode() != 3) break block5;
            }
            this._autoAck = true;
        }
        this.createQueue();
        this._alarm = new Alarm(this, 900000L);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append("JdbcQueueConsumer[").append(queue).append(",").append(this._consumerId).append("] created").toString());
        }
    }

    public Queue getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createQueue() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            String consumerSequence = this._jdbcManager.getConsumerSequence();
            String messageTable = this._jdbcManager.getMessageTable();
            Connection conn = dataSource.getConnection();
            try {
                if (consumerSequence != null) {
                    String sql = this._jdbcManager.getMetaData().selectSequenceSQL(consumerSequence);
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    long id = 0L;
                    ResultSet rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new RuntimeException("Expected result in customer create");
                    }
                    id = rs.getLong(1);
                    sql = new CharBuffer().append("INSERT INTO ").append(consumerTable).append(" (s_id, queue, expire) VALUES (?, ?,?)").toString();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, id);
                    pstmt.setInt(2, this._queue.getId());
                    pstmt.setLong(3, Alarm.getCurrentTime() + 3600000L);
                    pstmt.executeUpdate();
                } else {
                    String sql = new CharBuffer().append("INSERT INTO ").append(consumerTable).append(" (queue, expire) VALUES (?,?)").toString();
                    PreparedStatement pstmt = conn.prepareStatement(sql, 1);
                    pstmt.setInt(1, this._queue.getId());
                    pstmt.setLong(2, Alarm.getCurrentTime() + 3600000L);
                    pstmt.executeUpdate();
                    ResultSet rsKeys = pstmt.getGeneratedKeys();
                    if (!rsKeys.next()) {
                        throw new JMSException(L.l("consumer insert didn't create a key"));
                    }
                    this._consumerId = rsKeys.getLong(1);
                    rsKeys.close();
                    pstmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteQueue() throws JMSException {
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String consumerTable = this._jdbcManager.getConsumerTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("DELETE FROM ").append(consumerTable).append(" WHERE s_id=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, this._consumerId);
                pstmt.executeUpdate();
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MessageImpl receiveImpl() throws JMSException {
        try {
            this.purgeExpiredConsumers();
            this._queue.purgeExpiredMessages();
            long minId = -1L;
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                MessageImpl msg;
                int updateCount;
                String sql = new CharBuffer().append("SELECT m_id, msg_type, delivered, body, header FROM ").append(messageTable).append(" WHERE ?<m_id AND queue=?").append("   AND consumer IS NULL AND ?<=expire").append(" ORDER BY m_id").toString();
                PreparedStatement selectStmt = conn.prepareStatement(sql);
                try {
                    selectStmt.setFetchSize(1);
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                sql = this._autoAck ? new CharBuffer().append("DELETE FROM ").append(messageTable).append(" WHERE m_id=? AND consumer IS NULL").toString() : new CharBuffer().append("UPDATE ").append(messageTable).append(" SET consumer=?, delivered=1").append(" WHERE m_id=? AND consumer IS NULL").toString();
                PreparedStatement updateStmt = conn.prepareStatement(sql);
                long id = -1L;
                do {
                    id = -1L;
                    selectStmt.setLong(1, minId);
                    selectStmt.setInt(2, this._queue.getId());
                    selectStmt.setLong(3, Alarm.getCurrentTime());
                    msg = null;
                    ResultSet rs = selectStmt.executeQuery();
                    while (rs.next()) {
                        minId = id = rs.getLong(1);
                        msg = jdbcMessage.readMessage(rs);
                        if (this._selector == null || this._selector.isMatch(msg)) break;
                        msg = null;
                    }
                    rs.close();
                    if (msg == null) {
                        MessageImpl messageImpl = null;
                        return messageImpl;
                    }
                    if (this._autoAck) {
                        updateStmt.setLong(1, id);
                        continue;
                    }
                    updateStmt.setLong(1, this._consumerId);
                    updateStmt.setLong(2, id);
                } while ((updateCount = updateStmt.executeUpdate()) != 1);
                MessageImpl messageImpl = msg;
                return messageImpl;
            }
            finally {
                conn.close();
            }
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws JMSException {
        if (this._autoAck) {
            return;
        }
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("DELETE FROM ").append(messageTable).append(" ").append("WHERE consumer=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, this._consumerId);
                pstmt.executeUpdate();
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (this._autoAck) {
            return;
        }
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("UPDATE ").append(messageTable).append(" SET consumer=NULL ").append(" WHERE consumer=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, this._consumerId);
                pstmt.executeUpdate();
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeExpiredConsumers() {
        long now = Alarm.getCurrentTime();
        if (now < this._lastPurgeTime + 3600000L) {
            return;
        }
        this._lastPurgeTime = now;
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            String consumerTable = this._jdbcManager.getConsumerTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("UPDATE ").append(messageTable).append(" SET consumer=NULL").append(" WHERE consumer IS NOT NULL").append("  AND EXISTS(SELECT * FROM ").append(consumerTable).append("             WHERE s_id=consumer AND expire<?)").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime());
                int count = pstmt.executeUpdate();
                pstmt.close();
                if (count > 0) {
                    log.fine(new CharBuffer().append("JMSQueue[").append(this._queue.getName()).append("] recovered ").append(count).append(" messages").toString());
                }
                sql = new CharBuffer().append("DELETE FROM ").append(consumerTable).append(" WHERE expire<?").toString();
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime());
                pstmt.executeUpdate();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (this._isClosed) {
            return;
        }
        try {
            Connection conn = this._jdbcManager.getDataSource().getConnection();
            try {
                String consumerTable = this._jdbcManager.getConsumerTable();
                String sql = new CharBuffer().append("UPDATE ").append(consumerTable).append(" SET expire=?").append(" WHERE s_id=?").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime() + 3600000L);
                pstmt.setLong(2, this._consumerId);
                pstmt.executeUpdate();
            }
            finally {
                conn.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._alarm.queue(900000L);
        }
    }

    public void close() throws JMSException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        this._alarm.dequeue();
        try {
            this.deleteQueue();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        super.close();
    }

    public String toString() {
        return new CharBuffer().append("JdbcQueueConsumer[").append(this._queue).append(",").append(this._consumerId).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.jdbc.JdbcQueueConsumer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

