/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.message.BytesMessageImpl;
import com.caucho.jms.message.MapMessageImpl;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.ObjectMessageImpl;
import com.caucho.jms.message.StreamMessageImpl;
import com.caucho.jms.message.TextMessageImpl;
import com.caucho.jms.selector.Selector;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.ContextLoaderObjectInputStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.sql.DataSource;

public class JdbcMessage {
    static final Logger log = Log.open(JdbcMessage._resin_compat_class_0());
    static final L10N L = new L10N(JdbcMessage._resin_compat_class_0());
    private static final int MESSAGE = 0;
    private static final int TEXT = 1;
    private static final int BYTES = 2;
    private static final int STREAM = 3;
    private static final int OBJECT = 4;
    private static final int MAP = 5;
    private JdbcManager _jdbcManager;
    private DataSource _dataSource;
    private String _messageTable;
    private String _messageSequence;
    private static Class _resin_compat_class_0;

    public JdbcMessage(JdbcManager jdbcManager) {
        this._jdbcManager = jdbcManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException, SQLException {
        this._messageTable = this._jdbcManager.getMessageTable();
        this._dataSource = this._jdbcManager.getDataSource();
        JdbcMetaData metaData = this._jdbcManager.getMetaData();
        String identity = "";
        if (metaData.supportsIdentity()) {
            identity = " auto_increment";
        } else {
            this._messageSequence = new CharBuffer().append(this._messageTable).append("_cseq").toString();
        }
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = new CharBuffer().append("SELECT 1 FROM ").append(this._messageTable).append(" WHERE 1=0").toString();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                block8: {
                    log.finest(e.toString());
                    String blob = this._jdbcManager.getBlob();
                    String longType = this._jdbcManager.getLongType();
                    log.info(L.l("creating JMS message table {0}", this._messageTable));
                    sql = new CharBuffer().append("CREATE TABLE ").append(this._messageTable).append(" (").append("  m_id ").append(longType).append(" PRIMARY KEY").append(identity).append(",").append("  queue INTEGER NOT NULL,").append("  connection VARCHAR(255),").append("  consumer ").append(longType).append(",").append("  delivered INTEGER NOT NULL,").append("  msg_type INTEGER NOT NULL,").append("  expire ").append(longType).append(" NOT NULL,").append("  header ").append(blob).append(",").append("  body ").append(blob).append(")").toString();
                    stmt.executeUpdate(sql);
                    if (this._messageSequence == null) break block8;
                    stmt.executeUpdate(metaData.createSequenceSQL(this._messageSequence, 1));
                }
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long send(Message message, int queue, long expireTime) throws SQLException, IOException, JMSException {
        ObjectMessage obj;
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append("jms jdbc queue:").append(queue).append(" send message").toString());
        }
        TempStream header = new TempStream();
        header.openWrite();
        WriteStream ws = new WriteStream(header);
        this.writeMessageHeader(ws, message);
        ws.close();
        TempStream body = null;
        int type = 0;
        if (message instanceof TextMessage) {
            TextMessage text = (TextMessage)message;
            type = 1;
            if (text.getText() != null) {
                body = new TempStream();
                body.openWrite();
                ws = new WriteStream(body);
                ws.setEncoding("UTF-8");
                ws.print(text.getText());
                ws.close();
            }
        } else if (message instanceof BytesMessage) {
            BytesMessage bytes = (BytesMessage)message;
            type = 2;
            body = this.writeBytes(bytes);
        } else if (message instanceof StreamMessage) {
            StreamMessage stream = (StreamMessage)message;
            type = 3;
            body = this.writeStream(stream);
        } else if (message instanceof ObjectMessage) {
            obj = (ObjectMessage)message;
            type = 4;
            body = this.writeObject(obj);
        } else if (message instanceof MapMessage) {
            obj = (MapMessage)message;
            type = 5;
            body = this.writeMap((MapMessage)obj);
        }
        Connection conn = this._dataSource.getConnection();
        try {
            PreparedStatement pstmt;
            if (this._messageSequence != null) {
                String sql = this._jdbcManager.getMetaData().selectSequenceSQL(this._messageSequence);
                pstmt = conn.prepareStatement(sql);
                long mId = -1L;
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new RuntimeException("can't create message");
                }
                mId = rs.getLong(1);
                sql = new CharBuffer().append("INSERT INTO ").append(this._messageTable).append("(m_id, queue, msg_type, expire, delivered, header, body) ").append("VALUES (?,?,?,?,0,?,?)").toString();
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                pstmt.setLong(i++, mId);
                pstmt.setInt(i++, queue);
                pstmt.setInt(i++, type);
                pstmt.setLong(i++, expireTime);
                if (header.getLength() > 0) {
                    pstmt.setBinaryStream(i++, (InputStream)header.openRead(), header.getLength());
                } else {
                    pstmt.setNull(i++, 12);
                }
                if (body != null) {
                    pstmt.setBinaryStream(i++, (InputStream)body.openRead(), body.getLength());
                } else {
                    pstmt.setString(i++, "");
                }
                pstmt.executeUpdate();
            } else {
                String sql = new CharBuffer().append("INSERT INTO ").append(this._messageTable).append("(queue, msg_type, expire, delivered, header, body) ").append("VALUES (?,?,?,0,?,?)").toString();
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                pstmt.setInt(i++, queue);
                pstmt.setInt(i++, type);
                pstmt.setLong(i++, expireTime);
                pstmt.setBinaryStream(i++, (InputStream)header.openRead(), header.getLength());
                if (body != null) {
                    pstmt.setBinaryStream(i++, (InputStream)body.openRead(), body.getLength());
                } else {
                    pstmt.setString(i++, "");
                }
                pstmt.executeUpdate();
            }
            long l = 0L;
            return l;
        }
        finally {
            conn.close();
        }
    }

    MessageImpl receive(int queue, int session) throws SQLException, IOException, JMSException {
        long minId = -1L;
        Connection conn = this._dataSource.getConnection();
        try {
            String sql = new CharBuffer().append("SELECT m_id, msg_type, delivered, body, header FROM ").append(this._messageTable).append(" WHERE ?<id AND queue=? AND consumer IS NULL").append(" ORDER BY id").toString();
            PreparedStatement selectStmt = conn.prepareStatement(sql);
            sql = new CharBuffer().append("UPDATE ").append(this._messageTable).append(" SET consumer=?, delivered=1 ").append("WHERE m_id=? AND consumer IS NULL").toString();
            PreparedStatement updateStmt = conn.prepareStatement(sql);
            long id = -1L;
            while (true) {
                id = -1L;
                selectStmt.setLong(1, minId);
                selectStmt.setInt(2, queue);
                MessageImpl msg = null;
                ResultSet rs = selectStmt.executeQuery();
                while (rs.next()) {
                    minId = id = rs.getLong(1);
                    msg = this.readMessage(rs);
                }
                rs.close();
                if (msg == null) {
                    MessageImpl messageImpl = null;
                    return messageImpl;
                }
                updateStmt.setInt(1, session);
                updateStmt.setLong(2, id);
                int updateCount = updateStmt.executeUpdate();
                if (updateCount == 1) {
                    MessageImpl messageImpl = msg;
                    return messageImpl;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(new CharBuffer().append("JdbcMessageQueue[").append(queue).append("] can't update received message ").append(id).append(" for session ").append(session).append(".").toString());
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int session) throws SQLException {
        Connection conn = this._dataSource.getConnection();
        try {
            String sql = new CharBuffer().append("DELETE FROM ").append(this._messageTable).append(" ").append("WHERE consumer=?").toString();
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, session);
            pstmt.executeUpdate();
            pstmt.close();
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageImpl readMessage(ResultSet rs) throws SQLException, IOException, JMSException {
        MessageImpl msg;
        InputStream is;
        int msgType = rs.getInt(2);
        boolean redelivered = rs.getInt(3) == 1;
        switch (msgType) {
            case 1: {
                is = rs.getBinaryStream(4);
                try {
                    msg = this.readTextMessage(is);
                    break;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            case 2: {
                is = rs.getBinaryStream(4);
                try {
                    msg = this.readBytesMessage(is);
                    break;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            case 3: {
                is = rs.getBinaryStream(4);
                try {
                    msg = this.readStreamMessage(is);
                    break;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            case 4: {
                is = rs.getBinaryStream(4);
                try {
                    msg = this.readObjectMessage(is);
                    break;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            case 5: {
                is = rs.getBinaryStream(4);
                try {
                    msg = this.readMapMessage(is);
                    break;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            default: {
                msg = new MessageImpl();
            }
        }
        is = rs.getBinaryStream(5);
        if (is != null) {
            try {
                this.readMessageHeader(is, msg);
            }
            finally {
                is.close();
            }
        }
        msg.setJMSRedelivered(redelivered);
        return msg;
    }

    private void writeMessageHeader(WriteStream ws, Message msg) throws IOException, JMSException {
        Enumeration names = msg.getPropertyNames();
        CharBuffer cb = new CharBuffer();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.writeValue(ws, cb, name);
            String value = msg.getStringProperty(name);
            this.writeValue(ws, cb, value);
        }
    }

    private void writeValue(WriteStream ws, CharBuffer cb, Object value) throws IOException {
        if (value == null) {
            ws.write(78);
        } else {
            cb.clear();
            cb.append(value);
            int length = cb.length();
            char[] buf = cb.getBuffer();
            ws.write(83);
            ws.write(length >> 24);
            ws.write(length >> 16);
            ws.write(length >> 8);
            ws.write(length);
            for (int i = 0; i < length; ++i) {
                char ch = buf[i];
                ws.write(ch >> 8);
                ws.write(ch);
            }
        }
    }

    private TempStream writeBytes(BytesMessage bytes) throws IOException, JMSException {
        int data;
        TempStream body = new TempStream();
        body.openWrite();
        WriteStream ws = new WriteStream(body);
        while ((data = bytes.readUnsignedByte()) >= 0) {
            ws.write(data);
        }
        ws.close();
        return body;
    }

    private TempStream writeStream(StreamMessage stream) throws IOException, JMSException {
        TempStream body = new TempStream();
        body.openWrite();
        WriteStream ws = new WriteStream(body);
        ObjectOutputStream out = new ObjectOutputStream(ws);
        try {
            while (true) {
                Object data = stream.readObject();
                out.writeObject(data);
            }
        }
        catch (MessageEOFException e) {
            out.close();
            ws.close();
            return body;
        }
    }

    private TempStream writeObject(ObjectMessage obj) throws IOException, JMSException {
        TempStream body = new TempStream();
        body.openWrite();
        WriteStream ws = new WriteStream(body);
        ObjectOutputStream out = new ObjectOutputStream(ws);
        out.writeObject(obj.getObject());
        out.close();
        ws.close();
        return body;
    }

    private TempStream writeMap(MapMessage map) throws IOException, JMSException {
        TempStream body = new TempStream();
        body.openWrite();
        WriteStream ws = new WriteStream(body);
        ObjectOutputStream out = new ObjectOutputStream(ws);
        try {
            Enumeration e = map.getMapNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                out.writeUTF(name);
                Object data = map.getObject(name);
                out.writeObject(data);
            }
        }
        catch (MessageEOFException e) {
            // empty catch block
        }
        out.close();
        ws.close();
        return body;
    }

    private void readMessageHeader(InputStream is, Message msg) throws IOException, JMSException {
        int type;
        CharBuffer cb = new CharBuffer();
        while ((type = is.read()) > 0) {
            String name = (String)this.readValue(is, type, cb);
            Object value = this.readValue(is, is.read(), cb);
            msg.setObjectProperty(name, value);
        }
    }

    private TextMessageImpl readTextMessage(InputStream is) throws IOException, JMSException {
        int ch;
        TextMessageImpl text = new TextMessageImpl();
        if (is == null) {
            return text;
        }
        ByteToChar byteToChar = ByteToChar.create();
        byteToChar.setEncoding("UTF-8");
        while ((ch = is.read()) >= 0) {
            byteToChar.addByte(ch);
        }
        text.setText(byteToChar.getConvertedString());
        return text;
    }

    private BytesMessageImpl readBytesMessage(InputStream is) throws IOException, JMSException {
        int data;
        BytesMessageImpl bytes = new BytesMessageImpl();
        if (is == null) {
            bytes.reset();
            return bytes;
        }
        while ((data = is.read()) >= 0) {
            bytes.writeByte((byte)data);
        }
        bytes.reset();
        return bytes;
    }

    private StreamMessageImpl readStreamMessage(InputStream is) throws IOException, JMSException {
        StreamMessageImpl stream = new StreamMessageImpl();
        if (is == null) {
            return stream;
        }
        ContextLoaderObjectInputStream in = new ContextLoaderObjectInputStream(is);
        try {
            while (true) {
                Object obj = in.readObject();
                stream.writeObject(obj);
            }
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
        in.close();
        stream.reset();
        return stream;
    }

    private MapMessageImpl readMapMessage(InputStream is) throws IOException, JMSException {
        MapMessageImpl map = new MapMessageImpl();
        if (is == null) {
            return map;
        }
        ContextLoaderObjectInputStream in = new ContextLoaderObjectInputStream(is);
        try {
            while (true) {
                String name = in.readUTF();
                Object obj = in.readObject();
                map.setObject(name, obj);
            }
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
        in.close();
        return map;
    }

    private ObjectMessageImpl readObjectMessage(InputStream is) throws IOException, JMSException {
        ObjectMessageImpl msg = new ObjectMessageImpl();
        if (is == null) {
            return msg;
        }
        ContextLoaderObjectInputStream in = new ContextLoaderObjectInputStream(is);
        try {
            Object obj = in.readObject();
            msg.setObject((Serializable)obj);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
        in.close();
        return msg;
    }

    private Object readValue(InputStream is, int type, CharBuffer cb) throws IOException {
        switch (type) {
            case 78: {
                return null;
            }
            case 83: {
                cb.clear();
                int length = this.readInt(is);
                for (int i = 0; i < length; ++i) {
                    char ch = (char)((is.read() << 8) + is.read());
                    cb.append(ch);
                }
                return cb.toString();
            }
        }
        throw new IOException(L.l("unknown header type"));
    }

    private int readInt(InputStream is) throws IOException {
        return (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
    }

    private boolean hasMessage(Selector selector) throws JMSException {
        return false;
    }

    public String toString() {
        return new CharBuffer().append("JdbcMessage[").append(this._messageTable).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.jdbc.JdbcMessage");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

