/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.jms.jca.ManagedSessionImpl;
import com.caucho.jms.jca.MessageSenderManager;
import com.caucho.log.Log;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

class MessageSenderImpl
implements MessageSender {
    protected static final Logger log = Log.open(MessageSenderImpl._resin_compat_class_0());
    private static final L10N L = new L10N(MessageSenderImpl._resin_compat_class_0());
    private MessageSenderManager _manager;
    private ConnectionManager _cm;
    private static Class _resin_compat_class_0;

    MessageSenderImpl(MessageSenderManager manager, ConnectionManager cm) {
        this._manager = manager;
        this._cm = cm;
    }

    public void send(HashMap header, Object value) throws MessageServiceException {
        ManagedSessionImpl session = null;
        try {
            Message message;
            session = (ManagedSessionImpl)this._cm.allocateConnection((ManagedConnectionFactory)this._manager, null);
            if (value == null) {
                message = session.getSession().createMessage();
            } else if (value instanceof String) {
                message = session.getSession().createTextMessage((String)value);
            } else if (value instanceof Serializable) {
                ObjectMessage objMessage = session.getSession().createObjectMessage();
                objMessage.setObject((Serializable)value);
                message = objMessage;
            } else {
                throw new MessageServiceException(L.l("value '{0}' must be serializable", value));
            }
            session.send(message);
        }
        catch (MessageServiceException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MessageServiceException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.jca.MessageSenderImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

