/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.hessian;

import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.hessian.io.HessianInput;
import com.caucho.jms.AbstractQueue;
import com.caucho.jms.session.MessageAvailableListener;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public class HessianQueue
extends AbstractQueue
implements MessageSender {
    private static final Logger log = Log.open(HessianQueue._resin_compat_class_0());
    static L10N L = new L10N(HessianQueue._resin_compat_class_0());
    private String queueName;
    private String url;
    private Path path;
    private static Class _resin_compat_class_0;

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String name) {
        this.queueName = name;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = Vfs.lookup(this.url);
        }
        return this.path;
    }

    public void addListener(MessageAvailableListener listener) {
        throw new UnsupportedOperationException();
    }

    public void send(Message message) throws JMSException {
        try {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            Enumeration names = message.getPropertyNames();
            while (names != null && names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = message.getObjectProperty(name);
                headers.put(name, value);
            }
            if (message instanceof TextMessage) {
                this.send(headers, ((TextMessage)message).getText());
            } else if (message instanceof ObjectMessage) {
                this.send(headers, ((ObjectMessage)message).getObject());
            } else {
                this.send(headers, message);
            }
        }
        catch (Exception e) {
            throw new JMSException(String.valueOf(e));
        }
    }

    public void send(HashMap headers, Object data) throws MessageServiceException {
        ReadStream is = null;
        WriteStream os = null;
        try {
            ReadWritePair pair = this.getPath().openReadWrite();
            is = pair.getReadStream();
            os = pair.getWriteStream();
            HessianWriter out = new HessianWriter(os);
            HessianInput in = new HessianInput(is);
            out.startCall("send");
            out.writeObject(headers);
            out.writeObject(data);
            out.completeCall();
            os.flush();
            String status = (String)is.getAttribute("status");
            if (!"200".equals(status)) {
                int ch;
                CharBuffer errorMsg = new CharBuffer();
                while ((ch = is.readChar()) >= 0) {
                    errorMsg.append((char)ch);
                }
                throw new MessageServiceException(errorMsg.toString());
            }
            Object result = in.readReply(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new MessageServiceException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String toString() {
        return new CharBuffer().append("[HessianQueue ").append(this.queueName).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.hessian.HessianQueue");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

