/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SqlServerMetaData
extends JdbcMetaData {
    private static final Logger log = Log.open(SqlServerMetaData._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    protected SqlServerMetaData(DataSource ds) {
        super(ds);
    }

    public boolean supportsIdentity() {
        return true;
    }

    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        String type = null;
        switch (sqlType) {
            case 16: {
                type = this.getCreateColumnSQLImpl(-7, length, precision, scale);
                break;
            }
            case -6: {
                type = this.getCreateColumnSQLImpl(-6, length, precision, scale);
                break;
            }
            case 91: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 92: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 8: {
                type = this.getCreateColumnSQLImpl(6, length, precision, scale);
                break;
            }
            case 2: {
                type = this.getCreateColumnSQLImpl(2, length, precision, scale);
                break;
            }
            default: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
            }
        }
        if (type == null) {
            type = this.getDefaultCreateTableSQL(sqlType, length, precision, scale);
        }
        return type;
    }

    public String createIdentitySQL(String sqlType) {
        return " uniqueidentifier NOT NULL DEFAULT(NEWID())";
    }

    public String generateBoolean(String term) {
        return new CharBuffer().append(term).append("= 1").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jdbc.SqlServerMetaData");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

