/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OracleMetaData
extends JdbcMetaData {
    private static final Logger log = Log.open(OracleMetaData._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    protected OracleMetaData(DataSource ds) {
        super(ds);
    }

    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        switch (sqlType) {
            case 91: 
            case 92: {
                return "DATE";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return super.getCreateColumnSQL(sqlType, length, precision, scale);
    }

    public boolean supportsSequences() {
        return true;
    }

    public String createSequenceSQL(String name, int size) {
        if (size > 1) {
            return new CharBuffer().append("CREATE SEQUENCE ").append(name).append(" INCREMENT BY ").append(size).toString();
        }
        return new CharBuffer().append("CREATE SEQUENCE ").append(name).toString();
    }

    public String selectSequenceSQL(String name) {
        return new CharBuffer().append("SELECT ").append(name).append(".nextval FROM DUAL").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jdbc.OracleMetaData");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

