/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.MysqlMetaData;
import com.caucho.jdbc.OracleMetaData;
import com.caucho.jdbc.PostgresMetaData;
import com.caucho.jdbc.ResinMetaData;
import com.caucho.jdbc.SqlServerMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcMetaData {
    private static final L10N L = new L10N(JdbcMetaData._resin_compat_class_0());
    private static final Logger log = Log.open(JdbcMetaData._resin_compat_class_0());
    private DataSource _ds;
    private static Class _resin_compat_class_0;

    protected JdbcMetaData(DataSource ds) {
        this._ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcMetaData create(DataSource ds) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            String name = md.getDatabaseProductName();
            log.fine(L.l("Database '{0}' metadata.", name));
            if ("oracle".equalsIgnoreCase(name)) {
                OracleMetaData oracleMetaData = new OracleMetaData(ds);
                return oracleMetaData;
            }
            if ("resin".equalsIgnoreCase(name)) {
                ResinMetaData resinMetaData = new ResinMetaData(ds);
                return resinMetaData;
            }
            if ("postgres".equalsIgnoreCase(name) || "PostgreSQL".equalsIgnoreCase(name)) {
                PostgresMetaData postgresMetaData = new PostgresMetaData(ds);
                return postgresMetaData;
            }
            if ("mysql".equalsIgnoreCase(name)) {
                MysqlMetaData mysqlMetaData = new MysqlMetaData(ds);
                return mysqlMetaData;
            }
            if ("Microsoft SQL Server".equalsIgnoreCase(name)) {
                SqlServerMetaData sqlServerMetaData = new SqlServerMetaData(ds);
                return sqlServerMetaData;
            }
            log.fine(new CharBuffer().append(name).append(" is an unknown database type").toString());
            JdbcMetaData jdbcMetaData = new JdbcMetaData(ds);
            return jdbcMetaData;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            JdbcMetaData jdbcMetaData = new JdbcMetaData(ds);
            return jdbcMetaData;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseName() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            String string = md.getDatabaseProductName();
            return string;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            String string = "unknown";
            return string;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBlobType() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != 2004) continue;
                    String string = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    short dataType = rs.getShort("DATA_TYPE");
                    if (rs.getShort("DATA_TYPE") != -4) continue;
                    String e = rs.getString("TYPE_NAME");
                    return e;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != -2) continue;
                    String string = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                do {
                    if (!rs.next()) return null;
                } while (rs.getShort("DATA_TYPE") != -3);
                String string = rs.getString("TYPE_NAME");
                return string;
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLongType() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != -5) continue;
                    String string = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    public boolean supportsIdentity() {
        return false;
    }

    public String createIdentitySQL(String sqlType) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean supportsSequences() {
        return false;
    }

    public String createSequenceSQL(String name, int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String selectSequenceSQL(String name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String testSequenceSQL(String name) {
        return new CharBuffer().append(this.selectSequenceSQL(name)).append(" WHERE 1=0").toString();
    }

    public String generateBoolean(String term) {
        return term;
    }

    public String limit(String sql, int max) {
        return sql;
    }

    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        String type = null;
        switch (sqlType) {
            case 16: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(-7, length, precision, scale);
                break;
            }
            case 91: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 92: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 8: {
                type = this.getCreateColumnSQLImpl(8, length, precision, scale);
                break;
            }
            case 2: {
                type = this.getCreateColumnSQLImpl(2, length, precision, scale);
                break;
            }
            default: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
            }
        }
        if (type == null) {
            type = this.getDefaultCreateTableSQL(sqlType, length, precision, scale);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCreateColumnSQLImpl(int sqlType, int length, int precision, int scale) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != sqlType) continue;
                    String typeName = rs.getString("TYPE_NAME");
                    String params = rs.getString("CREATE_PARAMS");
                    if (params == null || params.equals("")) {
                        String string = typeName;
                        return string;
                    }
                    if (params.startsWith("(M)")) {
                        if (length > 0) {
                            String string = new CharBuffer().append(typeName).append("(").append(length).append(")").toString();
                            return string;
                        }
                        String string = typeName;
                        return string;
                    }
                    if (params.startsWith("(M,D)") || params.equals("precision,scale")) {
                        if (precision > 0) {
                            typeName = new CharBuffer().append(typeName).append("(").append(precision).toString();
                            if (scale > 0) {
                                typeName = new CharBuffer().append(typeName).append(",").append(scale).toString();
                            }
                            typeName = new CharBuffer().append(typeName).append(")").toString();
                        }
                        String string = typeName;
                        return string;
                    }
                    if (params.startsWith("(")) {
                        String value;
                        int tail = params.indexOf(41);
                        if (tail > 0) {
                            value = params.substring(1, tail);
                            boolean isConstant = true;
                            for (int i = 0; i < value.length(); ++i) {
                                if (value.charAt(i) >= 'a' && value.charAt(i) <= 'z') {
                                    isConstant = false;
                                    continue;
                                }
                                if (value.charAt(i) < 'A' || value.charAt(i) > 'Z') continue;
                                isConstant = false;
                            }
                            if (isConstant) {
                                String string = new CharBuffer().append(typeName).append("(").append(value).append(")").toString();
                                return string;
                            }
                        }
                        value = typeName;
                        return value;
                    }
                    String string = typeName;
                    return string;
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return null;
    }

    protected String getDefaultCreateTableSQL(int sqlType, int length, int precision, int scale) {
        switch (sqlType) {
            case 16: {
                return "CHAR";
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "INTEGER";
            }
            case 2: 
            case 3: {
                String typeString = "NUMERIC";
                if (precision > 0) {
                    typeString = new CharBuffer().append(typeString).append("(").append(precision).toString();
                    if (scale > 0) {
                        typeString = new CharBuffer().append(typeString).append(",").append(scale).toString();
                    }
                    typeString = new CharBuffer().append(typeString).append(")").toString();
                }
                return typeString;
            }
            case 6: 
            case 8: {
                return "DOUBLE";
            }
            case 1: {
                return "CHAR";
            }
            case 91: 
            case 92: 
            case 93: {
                return "TIMESTAMP";
            }
        }
        return new CharBuffer().append("VARCHAR(").append(length).append(")").toString();
    }

    protected Connection getConnection() throws SQLException {
        return this._ds.getConnection();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jdbc.JdbcMetaData");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

