/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;

public class JavaMailConfig {
    private static final L10N L = new L10N(JavaMailConfig._resin_compat_class_1());
    private static final Logger log = Log.open(JavaMailConfig._resin_compat_class_1());
    private Properties _props = new Properties();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setAttribute(String name, String value) {
        this._props.put(name, value);
    }

    public Object replaceObject() throws ConfigException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> sessionClass = Class.forName("javax.mail.Session", false, loader);
            Class<?> authClass = Class.forName("javax.mail.Authenticator", false, loader);
            Method method = sessionClass.getMethod("getInstance", JavaMailConfig._resin_compat_class_0(), authClass);
            Object obj = method.invoke(null, this._props, null);
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(L.l("javax.mail.Session is not available.  JavaMail must be downloaded separately from Sun."), e);
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.util.Properties");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.jca.cfg.JavaMailConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

