/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.CloseResource;
import com.caucho.jca.UserTransactionImpl;
import com.caucho.log.Log;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class UserTransactionProxy
implements UserTransaction {
    private static final Logger log = Log.open(UserTransactionProxy._resin_compat_class_0());
    private static final L10N L = new L10N(UserTransactionProxy._resin_compat_class_0());
    private static final UserTransactionProxy _proxy = new UserTransactionProxy();
    private static final ThreadLocal<UserTransactionImpl> _threadTransaction = new ThreadLocal();
    private static Class _resin_compat_class_0;

    private UserTransactionProxy() {
    }

    public static UserTransactionProxy getInstance() {
        return _proxy;
    }

    public UserTransactionImpl getTransaction() {
        UserTransactionImpl xa = _threadTransaction.get();
        if (xa == null) {
            xa = new UserTransactionImpl(TransactionManagerImpl.getLocal());
            _threadTransaction.set(xa);
        }
        return xa;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getTransaction().setTransactionTimeout(seconds);
    }

    public int getStatus() throws SystemException {
        return this.getTransaction().getStatus();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getTransaction().begin();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransaction().setRollbackOnly();
    }

    public void commit() throws IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        this.getTransaction().commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTransaction().rollback();
    }

    public void enlistCloseResource(CloseResource resource) throws IllegalStateException {
        this.getTransaction().enlistCloseResource(resource);
    }

    public void abortTransaction() throws IllegalStateException {
        UserTransactionImpl xa = _threadTransaction.get();
        if (xa == null) {
            return;
        }
        xa.abortTransaction();
    }

    void recover(XAResource xaRes) throws XAException {
        TransactionManagerImpl.getLocal().recover(xaRes);
    }

    public String toString() {
        return "UserTransactionProxy[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.UserTransactionProxy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

