/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.CloseResource;
import com.caucho.jca.PoolItem;
import com.caucho.jca.UserPoolItem;
import com.caucho.jca.UserTransactionSuspendState;
import com.caucho.log.Log;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class UserTransactionImpl
implements UserTransaction {
    private static final Logger log = Log.open(UserTransactionImpl._resin_compat_class_0());
    private static final L10N L = new L10N(UserTransactionImpl._resin_compat_class_0());
    private TransactionManagerImpl _transactionManager;
    private ArrayList<UserPoolItem> _resources = new ArrayList();
    private ArrayList<PoolItem> _poolItems = new ArrayList();
    private ArrayList<CloseResource> _closeResources = new ArrayList();
    private int _xaDepth;
    private static Class _resin_compat_class_0;

    public UserTransactionImpl(TransactionManagerImpl tm) {
        this._transactionManager = tm;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this._transactionManager.setTransactionTimeout(seconds);
    }

    public int getStatus() throws SystemException {
        return this._transactionManager.getStatus();
    }

    void enlistResource(UserPoolItem resource) throws SystemException, RollbackException {
        if (this._resources.contains(resource)) {
            return;
        }
        Transaction xa = this._transactionManager.getTransaction();
        if (xa != null) {
            PoolItem poolItem = resource.getXAPoolItem();
            this.enlistPoolItem(xa, poolItem);
        }
        this._resources.add(resource);
    }

    private void enlistPoolItem(Transaction xa, PoolItem poolItem) throws SystemException, RollbackException {
        TransactionImpl xaImpl;
        if (poolItem == null) {
            return;
        }
        if (!poolItem.supportsTransaction()) {
            return;
        }
        if (this._poolItems.contains(poolItem)) {
            return;
        }
        poolItem.setTransaction(this);
        if (xa instanceof TransactionImpl && (xaImpl = (TransactionImpl)xa).allowLocalTransactionOptimization()) {
            poolItem.enableLocalTransactionOptimization(true);
        }
        if (poolItem.getXid() == null) {
            xa.enlistResource((XAResource)poolItem);
        }
        this._poolItems.add(poolItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delistPoolItem(PoolItem poolItem, int flags) throws SystemException, RollbackException {
        Transaction xa = this._transactionManager.getTransaction();
        try {
            if (xa != null) {
                xa.delistResource((XAResource)poolItem, flags);
            }
        }
        finally {
            this._poolItems.remove(poolItem);
        }
    }

    void delistResource(UserPoolItem resource) {
        this._resources.remove(resource);
    }

    public void enlistCloseResource(CloseResource resource) {
        this._closeResources.add(resource);
    }

    UserPoolItem allocate(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (this._xaDepth == 0) {
            return null;
        }
        ArrayList<PoolItem> poolItems = this._poolItems;
        int length = poolItems.size();
        for (int i = 0; i < length; ++i) {
            PoolItem poolItem = poolItems.get(i);
            UserPoolItem item = poolItem.allocateXA(mcf, subject, info);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    PoolItem findJoin(PoolItem item) {
        if (this._xaDepth == 0) {
            return null;
        }
        ArrayList<PoolItem> poolItems = this._poolItems;
        int length = poolItems.size();
        for (int i = 0; i < length; ++i) {
            PoolItem poolItem = poolItems.get(i);
            if (!poolItem.isJoin(item)) continue;
            return poolItem;
        }
        return null;
    }

    public Xid getXid() throws SystemException, RollbackException {
        TransactionImpl xa = (TransactionImpl)this._transactionManager.getTransaction();
        if (xa != null) {
            return xa.getXid();
        }
        return null;
    }

    public int getEnlistedResourceCount() throws SystemException, RollbackException {
        TransactionImpl xa = (TransactionImpl)this._transactionManager.getTransaction();
        if (xa != null) {
            return xa.getEnlistedResourceCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws NotSupportedException, SystemException {
        block13: {
            ArrayList<PoolItem> recoveryList2;
            this._transactionManager.begin();
            ++this._xaDepth;
            boolean isOkay = false;
            try {
                int i;
                TransactionImpl xa = (TransactionImpl)this._transactionManager.getTransaction();
                xa.setUserTransaction(this);
                this._poolItems.clear();
                int length = this._resources.size();
                for (i = 0; i < length; ++i) {
                    PoolItem poolItem;
                    UserPoolItem userPoolItem = this._resources.get(i);
                    for (int j = this._poolItems.size() - 1; j >= 0 && !(poolItem = this._poolItems.get(j)).share(userPoolItem); --j) {
                    }
                    PoolItem xaPoolItem = userPoolItem.getXAPoolItem();
                    if (this._poolItems.contains(xaPoolItem)) continue;
                    this._poolItems.add(xaPoolItem);
                }
                for (i = 0; i < this._poolItems.size(); ++i) {
                    PoolItem poolItem = this._poolItems.get(i);
                    poolItem.enableLocalTransactionOptimization(this._poolItems.size() == 1);
                    try {
                        xa.enlistResource(poolItem);
                        continue;
                    }
                    catch (Exception e) {
                        throw new SystemException((Throwable)e);
                    }
                }
                isOkay = true;
                Object var9_10 = null;
                if (isOkay) break block13;
                log.warning("Rolling back transaction from failed begin()");
                --this._xaDepth;
                recoveryList2 = new ArrayList<PoolItem>(this._poolItems);
                this._poolItems.clear();
                this._resources.clear();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (!isOkay) {
                    log.warning("Rolling back transaction from failed begin()");
                    --this._xaDepth;
                    ArrayList<PoolItem> recoveryList2 = new ArrayList<PoolItem>(this._poolItems);
                    this._poolItems.clear();
                    this._resources.clear();
                    for (int i = 0; i < recoveryList2.size(); ++i) {
                        try {
                            PoolItem item = recoveryList2.get(i);
                            item.abortConnection();
                            item.destroy();
                            continue;
                        }
                        catch (Throwable e) {
                            log.log(Level.FINE, e.toString(), e);
                        }
                    }
                    this._transactionManager.rollback();
                }
                throw throwable;
            }
            for (int i = 0; i < recoveryList2.size(); ++i) {
                try {
                    PoolItem item = recoveryList2.get(i);
                    item.abortConnection();
                    item.destroy();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            this._transactionManager.rollback();
            {
            }
        }
    }

    public UserTransactionSuspendState suspend() {
        if (this._xaDepth == 0) {
            throw new IllegalStateException(L.l("suspend may only be called in a transaction."));
        }
        --this._xaDepth;
        UserTransactionSuspendState state = new UserTransactionSuspendState(this._poolItems);
        this._poolItems.clear();
        return state;
    }

    public void resume(UserTransactionSuspendState state) {
        ++this._xaDepth;
        this._poolItems.addAll(state.getPoolItems());
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this._transactionManager.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            this._transactionManager.commit();
        }
        finally {
            this._poolItems.clear();
            if (this._xaDepth > 0) {
                --this._xaDepth;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this._transactionManager.rollback();
        }
        finally {
            this._poolItems.clear();
            if (this._xaDepth > 0) {
                --this._xaDepth;
            }
        }
    }

    public void abortTransaction() throws IllegalStateException {
        IllegalStateException exn = null;
        boolean inTransaction = this._xaDepth > 0;
        this._xaDepth = 0;
        if (!inTransaction && this._poolItems.size() > 0) {
            IllegalStateException e = new IllegalStateException("user transaction pool broken");
            log.log(Level.WARNING, e.toString(), e);
        }
        this._poolItems.clear();
        if (inTransaction) {
            try {
                TransactionImpl xa = (TransactionImpl)this._transactionManager.getTransaction();
                exn = new IllegalStateException(L.l("Transactions must have a commit() or rollback() in a finally block."));
                log.warning("Rolling back dangling transaction.  All transactions must have a commit() or rollback() in a finally block.");
                this._transactionManager.rollback();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString());
            }
        }
        while (this._closeResources.size() > 0) {
            try {
                CloseResource resource = this._closeResources.remove(this._closeResources.size() - 1);
                resource.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._resources.size() > 0) {
            log.warning("Closing dangling connections.  All connections must have a close() in a finally block.");
        }
        while (this._resources.size() > 0) {
            UserPoolItem userPoolItem = this._resources.remove(this._resources.size() - 1);
            try {
                IllegalStateException stackTrace = userPoolItem.getAllocationStackTrace();
                if (stackTrace != null) {
                    log.log(Level.WARNING, stackTrace.getMessage(), stackTrace);
                } else {
                    userPoolItem.setSaveAllocationStackTrace(true);
                }
                if (exn == null) {
                    exn = new IllegalStateException(L.l("Connection {0} was not closed. Connections must have a close() in a finally block.", userPoolItem.getUserConnection()));
                }
                userPoolItem.abortConnection();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        this._poolItems.clear();
        try {
            this._transactionManager.setTransactionTimeout(0);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (exn != null) {
            throw exn;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.UserTransactionImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

