/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.PoolItem;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ThreadConnectionManager {
    private static final L10N L = new L10N(ThreadConnectionManager._resin_compat_class_0());
    private static final Logger log = Log.open(ThreadConnectionManager._resin_compat_class_0());
    private static final ThreadLocal<ThreadConnectionManager> _threadManager = new ThreadLocal();
    private ArrayList<SoftReference<PoolItem>> _activeConnections = new ArrayList();
    private static Class _resin_compat_class_0;

    public static ThreadConnectionManager getThreadManager() {
        return _threadManager.get();
    }

    public static void setThreadManager(ThreadConnectionManager manager) {
        _threadManager.set(manager);
    }

    public static ThreadConnectionManager createThreadManager() {
        ThreadConnectionManager cm = _threadManager.get();
        if (cm == null) {
            cm = new ThreadConnectionManager();
            _threadManager.set(cm);
        }
        return cm;
    }

    public static void addConnection(PoolItem conn) {
        ThreadConnectionManager.createThreadManager().add(conn);
    }

    public static void removeConnection(PoolItem conn) {
        ThreadConnectionManager.createThreadManager().remove(conn);
    }

    private void add(PoolItem conn) {
        this._activeConnections.add(new SoftReference<PoolItem>(conn));
    }

    private void remove(PoolItem conn) {
        for (int i = this._activeConnections.size() - 1; i >= 0; --i) {
            PoolItem aConn = this._activeConnections.get(i).get();
            if (aConn != null && aConn != conn) continue;
            this._activeConnections.remove(i);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.ThreadConnectionManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

