/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;

public class WorkDir {
    private static final EnvironmentLocal<Path> _localWorkDir = new EnvironmentLocal("caucho.work-dir");
    private Path _path;

    public static Path getLocalWorkDir() {
        return WorkDir.getLocalWorkDir(Thread.currentThread().getContextClassLoader());
    }

    public static Path getLocalWorkDir(ClassLoader loader) {
        Path path = _localWorkDir.get(loader);
        if (path != null) {
            return path;
        }
        path = CauchoSystem.isWindows() ? Vfs.lookup("file:/c:/tmp/caucho") : Vfs.lookup("file:/tmp/caucho");
        _localWorkDir.setGlobal(path);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static void setLocalWorkDir(Path path) {
        _localWorkDir.set(path);
    }

    public static void setLocalWorkDir(Path path, ClassLoader loader) {
        try {
            if (path instanceof MergePath) {
                path = ((MergePath)path).getWritePath();
            }
            if (path instanceof MemoryPath) {
                String pathName = path.getPath();
                path = Vfs.lookup(new CharBuffer().append("file:/tmp/caucho/qa/").append(pathName).toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        _localWorkDir.set(path, loader);
    }

    public void setValue(Path path) {
        this._path = path;
    }

    public void setId(Path path) throws IOException {
        this.setValue(path);
    }

    public void init() {
        WorkDir.setLocalWorkDir(this._path);
    }
}

