/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Iterator;

public class LineMapWriter {
    private WriteStream _os;

    public LineMapWriter(WriteStream os) {
        this._os = os;
    }

    public void write(LineMap lineMap) throws IOException {
        this._os.println("SMAP");
        this._os.println(lineMap.getDestFilename());
        this._os.println("JSP");
        this._os.println("*S JSP");
        IntMap fileMap = new IntMap();
        this._os.println("*F");
        Iterator<LineMap.Line> iter = lineMap.iterator();
        while (iter.hasNext()) {
            LineMap.Line line = iter.next();
            String filename = line.getSourceFilename();
            int index = fileMap.get(filename);
            if (index >= 0) continue;
            index = fileMap.size() + 1;
            fileMap.put(filename, index);
            if (filename.indexOf(47) >= 0) {
                int p = filename.lastIndexOf(47);
                this._os.println(new CharBuffer().append("+ ").append(index).append(" ").append(filename.substring(p + 1)).toString());
                if (filename.startsWith("/")) {
                    this._os.println(filename.substring(1));
                    continue;
                }
                this._os.println(filename);
                continue;
            }
            this._os.println(new CharBuffer().append(index).append(" ").append(filename).toString());
        }
        this._os.println("*L");
        int size = lineMap.size();
        boolean lastIndex = false;
        for (int i = 0; i < size; ++i) {
            LineMap.Line line = lineMap.get(i);
            String filename = line.getSourceFilename();
            int index = fileMap.get(filename);
            String fileMarker = "";
            this._os.print(line.getSourceLine());
            this._os.print(new CharBuffer().append("#").append(index).toString());
            if (line.getRepeatCount() > 1) {
                this._os.print(new CharBuffer().append(",").append(line.getRepeatCount()).toString());
            }
            this._os.print(":");
            this._os.print(line.getDestinationLine());
            if (line.getDestinationIncrement() > 1) {
                this._os.print(new CharBuffer().append(",").append(line.getDestinationIncrement()).toString());
            }
            this._os.println();
        }
        this._os.println("*E");
    }
}

