/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.bytecode.JClass;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class JavaWriter {
    private WriteStream _os;
    private int _indentDepth;
    private boolean _startLine = true;
    private LineMap _lineMap;
    private int _destLine = 1;
    private boolean _lastCr;
    private int _uniqueId;
    private static Class _resin_compat_class_0;

    public JavaWriter(WriteStream os) {
        this._os = os;
    }

    public WriteStream getWriteStream() {
        return this._os;
    }

    public int getDestLine() {
        return this._destLine;
    }

    public void setLineMap(LineMap lineMap) {
        this._lineMap = lineMap;
    }

    public LineMap getLineMap() {
        return this._lineMap;
    }

    public void setLocation(String filename, int line) throws IOException {
        if (this._lineMap != null && filename != null && line >= 0) {
            this._lineMap.add(filename, line, this._destLine);
        }
    }

    public int generateId() {
        return this._uniqueId++;
    }

    public void printJavaString(String s) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    this._os.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    this._os.print("\\n");
                    continue block6;
                }
                case '\r': {
                    this._os.print("\\r");
                    continue block6;
                }
                case '\"': {
                    this._os.print("\\\"");
                    continue block6;
                }
                default: {
                    this._os.print(ch);
                }
            }
        }
    }

    public void printJavaChar(char ch) throws IOException {
        switch (ch) {
            case '\\': {
                this._os.print("\\\\");
                break;
            }
            case '\n': {
                this._os.print("\\n");
                break;
            }
            case '\r': {
                this._os.print("\\r");
                break;
            }
            case '\'': {
                this._os.print("\\'");
                break;
            }
            default: {
                this._os.print(ch);
            }
        }
    }

    public void pushDepth() throws IOException {
        this._indentDepth += 2;
    }

    public void popDepth() throws IOException {
        this._indentDepth -= 2;
    }

    public void print(String s) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        if (s == null) {
            this._lastCr = false;
            this._os.print("null");
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\n' && !this._lastCr) {
                ++this._destLine;
            } else if (ch == '\r') {
                ++this._destLine;
            }
            this._lastCr = ch == '\r';
            this._os.print(ch);
        }
    }

    public void print(char ch) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        if (ch == '\r') {
            ++this._destLine;
        } else if (ch == '\n' && !this._lastCr) {
            ++this._destLine;
        }
        this._lastCr = ch == '\r';
        this._os.print(ch);
    }

    public void print(boolean b) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(b);
        this._lastCr = false;
    }

    public void print(int i) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(i);
        this._lastCr = false;
    }

    public void print(long l) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(l);
        this._lastCr = false;
    }

    public void print(Object o) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(o);
        this._lastCr = false;
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(boolean v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println(char ch) throws IOException {
        this.print(ch);
        this.println();
    }

    public void println(int v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println(long v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println(Object v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println() throws IOException {
        this._os.println();
        if (!this._lastCr) {
            ++this._destLine;
        }
        this._lastCr = false;
        this._startLine = true;
    }

    public void printClass(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName().replace('$', '.'));
        } else {
            this.printClass(cl.getComponentType());
            this.print("[]");
        }
    }

    public void printJavaTypeToObject(String value, Class javaType) throws IOException {
        if (JavaWriter._resin_compat_class_0().isAssignableFrom(javaType)) {
            this.print(value);
        } else if (javaType.equals(Boolean.TYPE)) {
            this.print(new CharBuffer().append("new Boolean(").append(value).append(")").toString());
        } else if (javaType.equals(Byte.TYPE)) {
            this.print(new CharBuffer().append("new Byte(").append(value).append(")").toString());
        } else if (javaType.equals(Short.TYPE)) {
            this.print(new CharBuffer().append("new Short(").append(value).append(")").toString());
        } else if (javaType.equals(Integer.TYPE)) {
            this.print(new CharBuffer().append("new Integer(").append(value).append(")").toString());
        } else if (javaType.equals(Long.TYPE)) {
            this.print(new CharBuffer().append("new Long(").append(value).append(")").toString());
        } else if (javaType.equals(Character.TYPE)) {
            this.print(new CharBuffer().append("String.valueOf(").append(value).append(")").toString());
        } else if (javaType.equals(Float.TYPE)) {
            this.print(new CharBuffer().append("new Float(").append(value).append(")").toString());
        } else if (javaType.equals(Double.TYPE)) {
            this.print(new CharBuffer().append("new Double(").append(value).append(")").toString());
        } else {
            this.print(value);
        }
    }

    public void printJavaTypeToObject(String value, JClass javaType) throws IOException {
        if (javaType.getName().equals("boolean")) {
            this.print(new CharBuffer().append("new Boolean(").append(value).append(")").toString());
        } else if (javaType.getName().equals("byte")) {
            this.print(new CharBuffer().append("new Byte(").append(value).append(")").toString());
        } else if (javaType.getName().equals("short")) {
            this.print(new CharBuffer().append("new Short(").append(value).append(")").toString());
        } else if (javaType.getName().equals("int")) {
            this.print(new CharBuffer().append("new Integer(").append(value).append(")").toString());
        } else if (javaType.getName().equals("long")) {
            this.print(new CharBuffer().append("new Long(").append(value).append(")").toString());
        } else if (javaType.getName().equals("char")) {
            this.print(new CharBuffer().append("String.valueOf(").append(value).append(")").toString());
        } else if (javaType.getName().equals("float")) {
            this.print(new CharBuffer().append("new Float(").append(value).append(")").toString());
        } else if (javaType.getName().equals("double")) {
            this.print(new CharBuffer().append("new Double(").append(value).append(")").toString());
        } else {
            this.print(value);
        }
    }

    public void printIndent() throws IOException {
        this._startLine = false;
        for (int i = 0; i < this._indentDepth; ++i) {
            this._os.print(' ');
        }
        this._lastCr = false;
    }

    public String errorMessage(String message) {
        return message;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

