/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployserver;

import com.caucho.config.ConfigException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPlan {
    private static final L10N L = new L10N(DeploymentPlan._resin_compat_class_0());
    private String _archiveType;
    private String _name;
    private ArrayList<ExtFile> _extFileList = new ArrayList();
    private static Class _resin_compat_class_0;

    public void setArchiveType(String type) throws ConfigException {
        if (!(type.equals("war") || type.equals("ear") || type.equals("rar"))) {
            throw new ConfigException(L.l("'{0}' is an unknown archive type.", type));
        }
        this._archiveType = type;
    }

    public String getArchiveType() {
        return this._archiveType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getArchiveName() {
        return new CharBuffer().append(this.getName()).append(".").append(this.getArchiveType()).toString();
    }

    public String getExpandName() {
        if (this._archiveType.equals("war")) {
            return this.getName();
        }
        return new CharBuffer().append("_").append(this._archiveType).append("_").append(this.getName()).toString();
    }

    public String getMetaPathName() {
        if (this._archiveType.equals("war")) {
            return new CharBuffer().append(this.getExpandName()).append("/WEB-INF").toString();
        }
        return new CharBuffer().append(this.getExpandName()).append("/META-INF").toString();
    }

    public void addExtFile(ExtFile file) {
        this._extFileList.add(file);
    }

    public ArrayList<ExtFile> getExtFileList() {
        return this._extFileList;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.j2ee.deployserver.DeploymentPlan");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class ExtFile {
        private String _name;
        private Node _data;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setData(Node data) {
            this._data = data.getFirstChild();
        }

        public Node getData() {
            return this._data;
        }
    }
}

